#ifndef EVIDENCEBAG_H
#define EVIDENCEBAG_H

#include "Evidence.h"
#include "Statement.h"
#include "Schema_Statement.h"

#include <cstdlib>
#include <string>
#include <list>
#include <vector>

class EvidenceBag : public Evidence {
public:
	EvidenceBag(const std::string name) : Evidence(name) {}
	EvidenceBag(const char *name) : Evidence(name) {}
	EvidenceBag(const std::string name, list<Evidence *> evidence) :
		Evidence(name), i_evidence(evidence) {}

	virtual ~EvidenceBag() {}

	virtual int atom() const { return 0; }
	virtual Statement* statement() {
		return i_schema_statement->correlate(decompose());
	}

protected:
	Schema_Statement*	i_schema_statement;
	Evidence*		i_evidence_bag;
	list< Evidence* >	i_evidence;
	int			i_status;
private:
};

#endif
