#ifndef EVIDENCE_BINARYIMAGE_H
#define EVIDENCE_BINARYIMAGE_H

#include "EvidenceBag.h"
#include "BinaryImage.h"

#include <cstdlib>

class Evidence_BinaryImage : public EvidenceBag {
public:
	Evidence_BinaryImage(const char *image, size_t size) :
		EvidenceBag("BinaryImage"), i_binaryimage(image, size) {}

	const char*	image() const { return i_binaryimage.image(); }
	int		print() const { return i_binaryimage.print(); }
	size_t		 size() const { return i_binaryimage.size();  }

	int		authority() const { return 1; }
	Statement*	statement() const;

protected:
	BinaryImage	i_binaryimage;
private:
};

#endif
