#ifndef EVIDENCE_BINARYIMAGE_FILE_H
#define EVIDENCE_BINARYIMAGE_FILE_H

#include "EvidenceBag.h"
#include "BinaryImage_File.h"

#include <cstdlib>

class Evidence_BinaryImage_File : public EvidenceBag {
public:
	Evidence_BinaryImage_File(const char *image, size_t size,
		const char *filename
	) :
		EvidenceBag("BinaryImage_File"),
		i_binaryimage_file(image, size, filename) {}

	const char*	image() const { return i_binaryimage_file.image(); }
	size_t		 size() const { return i_binaryimage_file.size();  }
	int		print() const { return i_binaryimage_file.print(); }

	int		authority() const { return 1; }
	Statement*	statement() const;

protected:
	BinaryImage_File	i_binaryimage_file;
private:
};

#endif
