#ifndef EVIDENCE_BINARYIMAGE_MAPPEDFILE_H
#define EVIDENCE_BINARYIMAGE_MAPPEDFILE_H

#include "EvidenceAtoms.h"
#include "EvidenceBag.h"
#include "BinaryImage_MappedFile.h"

#include <cstdlib>

class Evidence_BinaryImage_MappedFile : public EvidenceBag {
public:
	Evidence_BinaryImage_MappedFile(const char *image,
		size_t size, int address, const char *filename
	) :
		EvidenceBag("BinaryImage_MappedFile"),
		i_binaryimage_mappedfile(image, size, address, filename)
	{
		const size_t i_schema_size = 4;
		const int i_schema_matrix[] = {
			0, 1, 1, 1,
			0, 0, 1, 1,
			0, 0, 0, 1,
			0, 0, 0, 0
		};
		i_schema_statement = new Schema_Statement(i_schema_matrix,
			i_schema_size);
	}

	int address() const { return i_binaryimage_mappedfile.address(); }
	std::string filename() const { return i_binaryimage_mappedfile.filename(); }
	const char* image() const { return i_binaryimage_mappedfile.image(); }
	size_t size() const { return i_binaryimage_mappedfile.size(); }
	int print() const { return i_binaryimage_mappedfile.print(); }
	
	int molecule() const { return 1; }
	vector< Evidence* >* decompose() {
		vector< Evidence* > *v = new vector< Evidence* >;
		
		v->push_back(new EvidenceAtom_BinaryImage(
			std::string("TEXTIMAGE"), image(), size()));
		v->push_back(new EvidenceAtom_Integer(std::string("SIZE"), size()));
		v->push_back(new EvidenceAtom_Integer(std::string("ADDRESS"), address()));
		v->push_back(new EvidenceAtom_String(std::string("FILENAME"), filename()));

		return v;
	}

	int		authority() const { return 1; }
	Statement*	statement() { return NULL; }

protected:
	BinaryImage_MappedFile	i_binaryimage_mappedfile;
private:
};

#endif
