#ifndef KNOWLEDGEBASE_H
#define KNOWLEDGEBASE_H

#include "Decomposer.h"
#include "KnowledgeBase_Transducer.h"

#include <iostream.h>
#include <string>

class KnowledgeBase {
public:
	KnowledgeBase(const std::string name, Decomposer *decomposer);
	virtual ~KnowledgeBase();

	virtual int insert(Evidence *evidence, int flags) {
		int ret;
		ret = i_decomposer->decompose(evidence);
		return ret;
	}
	virtual int sync() { return 0; }

protected:
	std::string			i_name;
	Decomposer*			i_decomposer;
	int				i_status;
private:
};

#endif
