#include "KnowledgeBase_SchemaXML.h"

#include <string>
#include <iostream.h>

int
KnowledgeBase_SchemaXML::m_parse_isom_mapping(
	KnowledgeBase_Transducer *transducer, xmlDocPtr doc, xmlNodePtr root)
{
	xmlChar *from;
	xmlChar *to;
	int ret;

	from = xmlGetProp(root, (const xmlChar *)"FROM");
	to = xmlGetProp(root, (const xmlChar *)"TO");
cout << "ISMORPHISM: " << (char *)from << " --> " << (char *)to<< endl;

ret = transducer->insert( std::string((char *)from), std::string((char *)to) );
	return 0;
}

int
KnowledgeBase_SchemaXML::m_parse_isom_mappings(
	KnowledgeBase_Transducer *transducer, xmlDocPtr doc, xmlNodePtr root)
{
	for (xmlNodePtr p = root->xmlChildrenNode; p != NULL; p = p->next) {
		const char *name = (const char *)p->name;

		if (strcmp(name, "MAPPING") == 0) {
			int ret;
			ret = m_parse_isom_mapping(transducer, doc, p);
		}
	}
	return 0;
}

int
KnowledgeBase_SchemaXML::m_parse_homo_mappings(
	KnowledgeBase_Transducer *transducer, xmlDocPtr doc, xmlNodePtr root)
{
	for (xmlNodePtr p = root->xmlChildrenNode; p != NULL; p = p->next) {
		const char *name = (const char *)p->name;

		if (strcmp(name, "MAPPING") == 0) {
			xmlChar *table;
			xmlChar *column;

			 table = xmlGetProp(p, (const xmlChar *)"TABLE" );
			column = xmlGetProp(p, (const xmlChar *)"COLUMN");

cout << "HOMORPHISM: " << (char *)table << "=" << (char *)column << endl;
			xmlFree(column);
			xmlFree(table);
		}
	}
	return 0;
}

int
KnowledgeBase_SchemaXML::m_parse_knowledgebase(
	KnowledgeBase_Transducer *transducer, xmlDocPtr doc, xmlNodePtr root)
{
	for (xmlNodePtr p = root->xmlChildrenNode; p != NULL; p = p->next) {
		const char *name = (const char *)p->name;
		int ret;

		if (strcmp(name, "HOMOMORPHISM") == 0) {
			ret = m_parse_homo_mappings(transducer, doc, p);
		} else if (strcmp(name, "ISOMORPHISM") == 0) {
			ret = m_parse_isom_mappings(transducer, doc, p);
		}
	}
	return 0;
}

int
KnowledgeBase_SchemaXML::parse(const std::string filename,
	KnowledgeBase_Transducer *transducer)
{
	xmlNodePtr root;
	xmlDocPtr doc;

	doc = xmlParseFile(filename.data());
	root = xmlDocGetRootElement(doc);
	if (strcmp((const char *)root->name, "KNOWLEDGEBASE") == 0) {
		int ret;
		ret = m_parse_knowledgebase(transducer, doc, root);
	}
	xmlFreeDoc(doc);
	xmlCleanupParser();
	return 0;
}
