#include "Binary_ELF32_exec.h"

int
Binary_ELF32_exec::process_pt(Elf32_Phdr *p)
{
	const char *filename;

	if (p->p_type != PT_LOAD) return 0;

	filename = i_filename.data();
	if (p->p_offset == 0) {
		i_seg[0] = new Segment_ELF32(p, &i_m[p->p_offset], filename);
		return 0;
	} else {
		i_seg[1] = new Segment_ELF32(p, &i_m[p->p_offset], filename);
		return 1;
	}
	return 0;
}

Binary_ELF32_exec::Binary_ELF32_exec(const char *filename) :
	Binary_ELF32(filename)
{
	for (
		size_t i = 0;
		i < i_ehdr->e_phnum && process_pt(&i_phdr[i]) == 0;
		i++
	);
}

Binary_ELF32_exec::~Binary_ELF32_exec()
{
}
