#include "Process.h"

#include <iostream.h>

#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/wait.h>

Process::Process(int pid) : i_pid(pid), i_status(0)
{
}

Process::~Process()
{
	if (i_status != 0) detach();
}

int
Process::attach(void)
{
	int ret;

	ret = ptrace(PTRACE_ATTACH, i_pid, 0, 0);
	if (ret == 0) {
		i_status = 1;
		ret = waitpid(i_pid, NULL, WUNTRACED);
		if (ret >= 0)
			return 0;
	}
	return ret;
}

int
Process::detach(void)
{
	int ret;

	ret = ptrace(PTRACE_DETACH, i_pid, 0, 0);
	if (ret == 0) {
		i_status = 0;
	}
	return ret;
}

int
Process::peek(int address)
{
	int ret;

	if (i_status == 0) return -1;
	ret = ptrace(PTRACE_PEEKUSER, i_pid, address, 0);
	return ret;
}

int
Process::poke(int address, int data)
{
	int ret;

	if (i_status == 0) return -1;
	ret = ptrace(PTRACE_POKEUSER, i_pid, address, data);
	return ret;
}

#include <stdio.h>
int
Process::pull(char *m, int address, size_t size)
{
	size_t i;
	int *b = (int *)m;
	size_t r;

	if (i_status == 0) return -1;
	r = size & 3;
	size >>= 2;
	for (i = 0; i < size; i++, address += 4) {
		b[i] = peek(address);
	}
	if (r != 0) {
		int v;

		m = &m[i << 2];
		v = peek(address);
		for (i = 0; i < r; i++) {
			m[i] = v & 0xff;
			v >>= 8;
		}
	}
	return 0;
}
