#include "Binary_ELF32_exec.h"
#include "Generator_ELF32.h"
#include "Generator_Process.h"
#include "Signer_Copy.h"
#include "Signature_Copy.h"
#include "Authenticator_memcmp.h"
#include "Evidence.h"
#include "Evidence_BinaryImage_MappedFile.h"
#include "Detective.h"
#include "Process.h"
#include "Process_map.h"
#include "Designation.h"
#include "KnowledgeBase_MYSQL.h"
#include "KnowledgeBase_SchemaXML.h"
#include "Decomposer.h"
#include "Evidence_ProcessorPrint.h"
#include "Evidence_ProcessorTransducer.h"
#include "Agent_SchemaXML.h"

#include <iostream.h>
#include <unistd.h>

int
main(int argc, char *argv[])
{
	Generator *generator;
//	Signer *signer;
//	Signature *signature;
//	Authenticator *authenticator;
	Process *process;
	Detective *detective;
	Designation designation("designation 101");
	KnowledgeBase *kb;
	KnowledgeBase_Schema *kbs;
	KnowledgeBase_Transducer *transducer;
	Decomposer *decomposer;
	Evidence_Processor *processor;
	Agent_SchemaXML *ab;

	if (argc != 2) exit(1);


//	generator = new Generator_ELF32(argv[1]);
//	signer = new Signer_Copy;
//	signature = new Signature_Copy;
//	authenticator = new Authenticator_memcmp;

	process = new Process(atoi(argv[1]));
	generator = new Generator_Process(*process);

	transducer = new KnowledgeBase_Transducer();
	kbs = new KnowledgeBase_SchemaXML();
	kbs->parse("etc/schemas/knowledgebase.xml", transducer);
	processor = new Evidence_ProcessorTransducer(transducer);
	decomposer = new Decomposer(processor);

	kb = new KnowledgeBase_MYSQL("kb", decomposer);

	detective = new Detective(designation, kb);
	detective->associate(generator);
	detective->investigate();

	ab = new Agent_SchemaXML();
	ab->parse(std::string("etc/schemas/agentbase.xml"), detective);
#if 0
	Generator *g1, *g2;
	Signer *s1, *s2;
	Signature *si1, *si2;
	Authenticator *a;


	g1 = new Generator_ELF32(argv[1]);
	s1 = new Signer_Copy;
	si1 = new Signature_Copy;
	s1->sign(g1, si1);

	g2 = new Generator_ELF32(argv[2]);
	s2 = new Signer_Copy;
	si2 = new Signature_Copy;
	s2->sign(g2, si2);

	a = new Authenticator_memcmp;
	cout << a->equal(si1, si2) << endl;

	Process p(4356);
	Process_map pm(p);
#endif
	return 0;
}
