#ifndef EVIDENCEATOM_H
#define EVIDENCEATOM_H

#include "Evidence.h"

#include <cstdlib>
#include <string>

struct EvidenceAtom_binaryimage_s {
	char*	i_binaryimage;
	size_t	i_size;
} EvidenceAtom_binaryimage_t;

typedef struct EvidenceAtom_string_s {
	char*	i_string;
	size_t	i_size;
} EvidenceAtom_string_t;

typedef enum {
	EVIDENCEATOM_STRING,
	EVIDENCEATOM_BINARYIMAGE,
	EVIDENCEATOM_S32,
	EVIDENCEATOM_U32,
	EVIDENCEATOM_S16,
	EVIDENCEATOM_U16,
	EVIDENCEATOM_S8,
	EVIDENCEATOM_U8,
} EvidenceAtom_type_e;

class EvidenceAtom : public Evidence {
public:
	EvidenceAtom(std::string key, int integer, int type) :
		i_atom.i_u32(integer) {}
	EvidenceAtom(std::string key, const char *image, size_t size) {
		char *p;
		i_atom.i_binaryimage.i_size = size;
		i_atom.i_binaryimage.i_image = p = new char[size];
		std::copy(p, p + size, image);
	}
	EvidenceAtom(std::string key, std::string s) {
		size_t size;
		char *p;
		size = s.length();
		i_atom.i_string.i_size = size;
		i_atom.i_string.i_string = p = new char[size];
		std::copy(p, p + size, s.data());
	}
	

	~EvidenceAtom() {}

protected:
private:
	union {
		int				i_s32;
		unsigned int			i_u32;
		short int			i_s16;
		unsigned short int		i_u16;
		char				i_s8;
		unsigned char			i_u8;
		EvidenceAtom_string_t		i_string;
		EvidenceAtom_binaryimage_t	i_binaryimage;
	} i_atom;
	EvidenceAtom_type_e			type;
};

#endif
