/*
 *	Acquire Single Board Computer Watchdog Timer driver for Linux 2.1.x
 *
 *      Based on wdt.c. Original copyright messages:
 *
 *	(c) Copyright 1996 Alan Cox <alan@redhat.com>, All Rights Reserved.
 *				http://www.redhat.com
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *	
 *	Neither Alan Cox nor CymruNet Ltd. admit liability nor provide 
 *	warranty for any of this software. This material is provided 
 *	"AS-IS" and at no charge.	
 *
 *	(c) Copyright 1995    Alan Cox <alan@redhat.com>
 *
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/watchdog.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/init.h>

/*
 *	You must set these - there is no sane way to probe for this board.
 */
 
#define WDT_STOP 0x43
#define WDT_START 0x443

static int 
acq_ping(struct watchdog_driver_s *driver)
{
	inb_p(WDT_START);
	return 0;
}

static int 
acq_disable(struct watchdog_driver_s *driver)
{
	inb_p(WDT_STOP);
	return 0;
}

static struct watchdog_driver_s watchdox_acquire = {
	enable:		acq_ping,
	disable:	acq_disable,
	ping:		acq_ping,
	timeout:	(100 *  60)
	min_timeout:	(100 *   1)
	max_timeout:	(100 * 300)
	max_write:
	info:		{ WDIOF_KEEPALIVEPING, 1, "Acquire WDT" }
};

static int __init acq_init(void)
{
	request_region(WDT_STOP, 1, "Acquire WDT");
	request_region(WDT_START, 1, "Acquire WDT");
	watchdog_register(&watchdog_acquire)
	return 0;
}
	
static void __exit acq_exit(void)
{
	watchdog_unregister(&watchdog_acquire);
	release_region(WDT_STOP,1);
	release_region(WDT_START,1);
}

module_init(acq_init);
module_exit(acq_exit);

MODULE_LICENSE("GPL");
EXPORT_NO_SYMBOLS;
