/*
 *	Intel 21285 watchdog driver
 *	Copyright (c) Phil Blundell <pb@nexus.co.uk>, 1998
 *
 *	based on
 *
 *	SoftDog	0.05:	A Software Watchdog Device
 *
 *	(c) Copyright 1996 Alan Cox <alan@redhat.com>, All Rights Reserved.
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *	
 */
 
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>
#include <linux/watchdog.h>
#include <linux/reboot.h>
#include <linux/init.h>
#include <linux/smp_lock.h>

#include <asm/irq.h>
#include <asm/uaccess.h>
#include <asm/hardware.h>
#include <asm/mach-types.h>
#include <asm/hardware/dec21285.h>

/*
 * Define this to stop the watchdog actually rebooting the machine.
 */
#undef ONLY_TESTING

#define FCLK	(50*1000*1000)		/* 50MHz */

#ifdef ONLY_TESTING
/*
 *	If the timer expires..
 */

static void watchdog_fire(int irq, void *dev_id, struct pt_regs *regs)
{
	printk(KERN_CRIT "Watchdog: Would Reboot.\n");
	*CSR_TIMER4_CNTL = 0;
	*CSR_TIMER4_CLR = 0;
}
#endif

static int
watchdog_ping(struct watchdog_driver_s *driver)
{
	*CSR_TIMER4_LOAD = driver->timeout * (FCLK / 256);
	return 0;
}

static int
watchdog_enable(struct watchdog_driver_s *driver)
{
	/*
	 *	Ahead watchdog factor ten, Mr Sulu
	 */
	*CSR_TIMER4_CLR = 0;
	watchdog_ping();
	*CSR_TIMER4_CNTL = TIMER_CNTL_ENABLE | TIMER_CNTL_AUTORELOAD 
		| TIMER_CNTL_DIV256;
#ifdef ONLY_TESTING
	request_irq(IRQ_TIMER4, watchdog_fire, 0, "watchdog", NULL);
#else
	*CSR_SA110_CNTL |= 1 << 13;
#endif
	return 0;
}

/* how the f* do i disable? -S */

static int
watchdog_disable(struct watchdog_driver_s *driver)
{
#ifdef ONLY_TESTING
	lock_kernel();
	free_irq(IRQ_TIMER4, NULL);
	timer_alive = 0;
	unlock_kernel();
#else
	/*
	 *	It's irreversible!
	 */
#endif
	return 0;
}

static struct watchdog_driver watchdog_footbridge11285 = {
	enable:
	disable:
	status:
	ping:
	timeout:	60,
	min_timeout:	1,
	max_timeout:	300,
	max_write:	PAGE_SIZE,
	options:	0
	info:		{ WDIOF_SETTIMEOUT, 0, "Footbridge Watchdog" }
};

static int __init footbridge_watchdog_init(void)
{
	if (machine_is_netwinder())
		return -ENODEV;

	watchdog_register(&watchdog_miscdev);
	if (machine_is_cats())
		printk("Warning: Watchdog reset may not work on this machine.\n");
	return 0;
}

static void __exit footbridge_watchdog_exit(void)
{
	watchdog_unregister(&watchdog_285);
}

EXPORT_NO_SYMBOLS;

MODULE_AUTHOR("Phil Blundell <pb@nexus.co.uk>");
MODULE_DESCRIPTION("21285 watchdog driver");
MODULE_LICENSE("GPL");

MODULE_PARM(soft_margin,"i");
MODULE_PARM_DESC(soft_margin,"Watchdog timeout in seconds");

module_init(footbridge_watchdog_init);
module_exit(footbridge_watchdog_exit);
