/*
 *	Wdt977	0.01:	A Watchdog Device for Netwinder W83977AF chip
 *
 *	(c) Copyright 1998 Rebel.com (Woody Suwalski <woody@netwinder.org>)
 *
 *			-----------------------
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 *
 *			-----------------------
 */
 
#include <linux/module.h>
#include <linux/config.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/miscdevice.h>
#include <linux/init.h>
#include <linux/smp_lock.h>

#include <asm/io.h>
#include <asm/system.h>
#include <asm/mach-types.h>

static int
wdt977_enable(struct watchdog_driver_s *driver)
{
	// unlock the SuperIO chip
	outb(0x87,0x370); 
	outb(0x87,0x370); 
	
	//select device Aux2 (device=8) and set watchdog regs F2, F3 and F4
	//F2 has the timeout in minutes
	//F3 could be set to the POWER LED blink (with GP17 set to PowerLed)
	//   at timeout, and to reset timer on kbd/mouse activity (not now)
	//F4 is used to just clear the TIMEOUT'ed state (bit 0)
	
	outb(0x07,0x370);
	outb(0x08,0x371);
	outb(0xF2,0x370);
	outb(timeout,0x371);
	outb(0xF3,0x370);
	outb(0x00,0x371);	//another setting is 0E for kbd/mouse/LED
	outb(0xF4,0x370);
	outb(0x00,0x371);
	
	//at last select device Aux1 (dev=7) and set GP16 as a watchdog output
#ifdef WATCHDOG_977_DEBUG
	outb(0x07,0x370);
	outb(0x07,0x371);
	outb(0xE6,0x370);
	outb(0x08,0x371);
#endif
		
	// lock the SuperIO chip
	outb(0xAA,0x370); 

	return 0;
}

static int
wdt977_disable(struct watchdog_driver_s *driver)
{
	// unlock the SuperIO chip
	outb(0x87,0x370); 
	outb(0x87,0x370); 
	
	//select device Aux2 (device=8) and set watchdog regs F2,F3 and F4
	//F3 is reset to its default state
	//F4 can clear the TIMEOUT'ed state (bit 0) - back to default
	//We can not use GP17 as a PowerLed, as we use its usage as a RedLed
	
	outb(0x07,0x370);
	outb(0x08,0x371);
	outb(0xF2,0x370);
	outb(0xFF,0x371);
	outb(0xF3,0x370);
	outb(0x00,0x371);
	outb(0xF4,0x370);
	outb(0x00,0x371);
	outb(0xF2,0x370);
	outb(0x00,0x371);
	
	//at last select device Aux1 (dev=7) and set GP16 as a watchdog output
	outb(0x07,0x370);
	outb(0x07,0x371);
	outb(0xE6,0x370);
	outb(0x08,0x371);
	
	// lock the SuperIO chip
	outb(0xAA,0x370);

	return 0;
}

static int
wdt977_ping(struct watchdog_driver_s *driver)
{
	//we have a hw bug somewhere, so each 977 minute is actually only 30sec
	//as such limit the max timeout to half of max of 255 minutes...
	
	// unlock the SuperIO chip
	outb(0x87,0x370); 
	outb(0x87,0x370); 
	
	//select device Aux2 (device=8) and kicks watchdog reg F2
	//F2 has the timeout in minutes
	
	outb(0x07,0x370);
	outb(0x08,0x371);
	outb(0xF2,0x370);
	outb(timeout,0x371);
	
	// lock the SuperIO chip
	outb(0xAA,0x370); 
	
	return 0;
}

static struct watchdog_driver_s watchdog_977 = {
	enable:		wtd977_enable,
	disable:	wtd977_disable,
	ping:		wtd977_ping,
	timeout:	60,
	max_write:	PAGE_SIZE,
	min_timeout:	1,
	max_timeout:	126,
	info:
};

static int __init nwwatchdog_init(void)
{
	if (!machine_is_netwinder())
		return -ENODEV;

	watchdog_register(&watchdog_977);
	return 0;
}	

static void __exit nwwatchdog_exit(void)
{
	watchdog_unregister(&watchdog_977);
}

EXPORT_NO_SYMBOLS;

module_init(nwwatchdog_init);
module_exit(nwwatchdog_exit);

MODULE_LICENSE("GPL");
