#ifndef _LINUX_WATCHDOG_H
#define _LINUX_WATCHDOG_H

#include <linux/watchdog_ioctl.h>
#include <linux/notifier.h>
#include <linux/miscdevice.h>

#define LINUX_WATCHDOG_OPT_TIMER
#define LINUX_WATCHDOG_OPT_EXCLUSIVE
#define LINUX_WATCHDOG_OPT_INTERRUPT

struct watchdog_interface {
	int	(*enable)	(struct watchdog_driver_s *);
	int	(*disable)	(struct watchdog_driver_s *);
	int	(*ping)		(struct watchdog_driver_s *);
	int	(*status)	(struct watchdog_driver_s *);
	void	(*interrupt)	(int irq, void *dev_id, struct pt_regs *regs);

	struct watchdog_info	info;

	int			driver_status;
	int			options;
	size_t			max_write;
	int			timeout;
	int			min_timeout;
	int			max_timeout;

	int			irq;
	int			irq_flags;
	int			io;
	int			io_region_size;

/* internal */
	int			state;
	struct timer_list	timer;
	int			next_timer;
	struct miscdevice	device;
	struct notifier_block	reboot_notification;
	spinlock_t		spinlock;
};

#endif
