#!/usr/bin/python

from Instr import *
from Arch import *

import string
import os
import re

objdump_binary = "/usr/bin/objdump"
objdump_opt = " -b binary -m i386 --prefix-addresses -D "

r1 = re.compile("(?:(0x[0-9a-f]{8}) ([a-z][a-z0-9]+) +(.+))|(?:(0x[0-9a-f]{8}) ([a-z][a-z0-9]+)$)")

class Disassem:
#
# @p_filename
# @p_asm = {}
# 
#
	def process_image(self, image, binary):
		c = '%s %s --adjust-vma=%s %s' % (objdump_binary, objdump_opt, image.p_addr, binary.p_filename)

		print c
		f = os.popen(c, "r")
		if not f:
			return -1
		while 1:
			line = f.readline()
			if not line:
				break
			m = r1.match(line)
			if not m:
				print 'FUCK, NO MATCH', line
				continue
			if not m.group(1):
				a = m.group(4)
				n = m.group(5)
				p = ''
			else:
				a = m.group(1)
				n = m.group(2)
				p = m.group(3)
			self.p_dasm[a] = Instr(self.p_arch, a, n, p)
		f.close()

	def __init__(self, arch, binary):
		self.p_arch = arch
		self.p_dasm = {}

		for image in binary.p_image:
			if image.p_offset == "0x000000":
				self.process_image(image, binary)
			else:
				print 'SKIPPING IMAGE', image.p_offset


#
# FIXME: erm. yah.
#
	def m_npc(self, pc):
		for i in range(0, 13):
			pc10 = string.atoi(pc, 16)
			pc10 = pc10 + 1
			pc = "0x%08x" % (pc10)
			if self.p_dasm.has_key(pc):
				return pc

	def m_ppc(self, pc):
		for i in range(0, 13):
			pc10 = string.atoi(pc, 16)
			pc10 = pc10 - 1
			pc = "0x%08x" % (pc10)
			if self.p_dasm.has_key(pc):
				return pc
		return None
