#!/usr/bin/python

import cPickle
import getopt
import os
import sys

d = '/root/src/python/flowgraph-0.0.23'
sys.path.append(d + '/src/')
sys.path.append(d + '/src/graph/')
sys.path.append(d + '/src/prologue/')
sys.path.append(d + '/src/bug/')
sys.path.append(d + '/src/proc/')
sys.path.append(d + '/src/proc_external/')

from Printer import *
from Program import *
from Data import *

import string


def print_proc(program, proc, f):
	f.write('PROCEDURE\n')
	f.write('addr=%s\n' % (proc.p_address))
	f.write('name=%s\n' % (program.p_symtab.pc2name(proc.p_address)))
	f.write('lvar.total_size=%s\n' % (proc.p_var_local))
	if proc.p_procargs:
		f.write('argc=%i\n' % (len(proc.p_procargs.p_vars)))
		for k in proc.p_procargs.p_vars.keys():
			v = proc.p_procargs.p_vars[k]
			f.write('argv[%s].p_size=%s\n' % (k, v.p_size))
	f.write('calls %i\n' % (len(proc.p_procs)))
	f.write('END\n')
	f.close()
def usage():
	sys.exit(0)

#
#

p = cPickle.load(open('/root/src/python/flowgraph-0.0.23/IBA.db'))
proc = p.p_graph.p_nodes[sys.argv[1]].p_val
print_proc(p, proc, sys.stdout)

sys.exit(0)
