#!/usr/bin/python

import string
import re

re_cbranch = re.compile("^(j[^m]+)")
re_ubranch = re.compile("^(jmp)")
re_call = re.compile("^(call)")
re_ret = re.compile("^(ret)|^(hlt)")
re_a = re.compile("0x(0[0-9a-f]{7})")

class InstrArg:
#
#
#
#
	def __init__(self, arch, param):
		self.p_arch = arch
		self.p_param = param
		self.p_im = arch.im_match(param)
		if param == '':
			print 'NOTHING'
			return None
		if not self.p_im:
			print 'NOTHING222'
			return None
		self.p_match = self.p_im.p_regexp_grouping.match(param)
		if not self.p_match:
			print 'FUCK, NO MATCH'
			return None
		if not self.p_match:
			print 'FFUCK'

# FIXME: look in Arch
#		if not self.p_im:
#			print 'FUCK', param

class Instr:
#
# @p_mnemonic
# @p_params
# @p_paramv
# @p_pc
# @p_size
#
#
	def __init__(self, arch, pc, mnemonic, params, size = None):
		self.p_arch = arch
		self.p_mnemonic = mnemonic
		self.p_params = params
		self.p_pc = pc
		self.p_size = size
		self.p_argv = []

		self.p_tagged = None
		self.p_type = "unknown"
		self.p_hasnpc = 1
		self.p_jumpto = None

		if len(params) != 1:
			self.p_paramv = [ "" ]
			c = 0
			s = 0
			for ch in params:
				if ch == '(':
					s = s + 1
				elif ch == ')':
					s = s - 1
				elif ch == ',':
					if s == 0:
						c = c + 1
						self.p_paramv.append("")
						continue
				elif ch == '<':
					break
				self.p_paramv[c] = self.p_paramv[c] + ch

			for v in self.p_paramv:
				self.p_argv.append(InstrArg(arch, v))

		self.p_datadeps = arch.datadeps(mnemonic, self.p_argv)

		cm = re_cbranch.match(mnemonic)
		if cm:
			self.p_type = "cjmp"
			cm = re_a.match(params)
			if not cm:
				return
			cn = "0x%08x" % (string.atoi('0x' + cm.group(1), 16))
			self.p_jumpto = cn
		else:
			um = re_ubranch.match(mnemonic)
			if um:
				self.p_type = "ujmp"
				um = re_a.match(params)
				if not um:
					return
				un = "0x%08x" % (string.atoi('0x' + um.group(1), 16))
				self.p_jumpto = un
				self.p_hasnpc = None
			else:
				lm = re_call.match(mnemonic)
				if lm:
					lm = re_a.match(params)
					if not lm:
						return
					self.p_type = "call"
					ln = "0x%08x" % (string.atoi('0x' + lm.group(1), 16))
					
					self.p_jumpto = ln
					print 'GOT A CALL', ln, mnemonic, params
				else:
					km = re_ret.match(mnemonic)
					if km:
						self.p_hasnpc = None
						self.p_type = "ret"
