#!/usr/bin/python

from Library import *

import sys
import os
import re

readelf_binary = "/usr/bin/readelf"
readelf_opt = " -d "
readelf_regexp = re.compile(" 0x00000001 \(NEEDED\)[ ]+Shared library: \[(.*)\]")

class RTLinking:
#
# @p_external = []
#
#
	def __init__(self, filename="a.out"):
		c = readelf_binary + readelf_opt + filename
		f = os.popen(c, "r")
		if not f:
			return
		self.p_external = []
		for line in f.readlines():
			m = readelf_regexp.match(line)
			if not m:
				continue
			name = m.group(1)
			l = Library(name)
			self.p_external.append(l)
		f.close()

	def printer(self):
		print 'subgraph cluster_RTLinking {'
		for l in self.p_external:
			print '"' + l.p_name +'" -> PROGRAM [color=purple];'
		print '}'

#if len(sys.argv) != 2:
#	sys.exit(0)
#l = RTLinking(sys.argv[1])
#l.printer()
