#!/usr/bin/python

import getopt
import os
import sys

d = os.getcwd()
sys.path.append(d + '/src/')
sys.path.append(d + '/src/graph/')
sys.path.append(d + '/src/prologue/')
sys.path.append(d + '/src/bug/')
sys.path.append(d + '/src/proc/')
sys.path.append(d + '/src/proc_external/')

from Printer import *
from Program import *
from Data import *

import shelve
import string

def usage():
	print "usage: FIXME [-l library ] filename"
	sys.exit(0)

#
#

libraries = []
symbols = []

#
#

opts, args = getopt.getopt(sys.argv[1:], 'l:s:')

for o, a in opts:
	if o == '-l':
		libraries.append(a)
	elif o == '-s':
		symbols.append(a)

if len(args) != 1:
	usage()

target = args[0]

#
#

p = Program(target, symbols, libraries)
p.run()

d = shelve.open('IBA.db')
d['program'] = p
d.close()

d = shelve.open('IBA.db')
q = d['program']
d.close()

Printer().run(q)
sys.exit(0)

#g = p.p_graph.paths('0x08048320', '0x08048350')
for k in p.p_graph.p_nodes.keys():
	proc = p.p_graph.p_nodes[k].p_val
	n = p.p_symtab.pc2name(proc.p_address)
	if n != "main":
		continue
	s = proc.p_graph.simple(proc.p_address)
	Data().run(p, proc, s)
	for k in s.p_edges.keys():
		e = s.p_edges[k]
		p1 = e.p_node1.p_key
		p2 = e.p_node2.p_key
		print '"' + p1 + '" -> "' + p2 + '"',
		print ';'
