#!/usr/bin/python

import string
import ConfigParser

import os
import sys
from array import array
from stat import *

class Prologue:
#
# @p_description
# @p_config_filename
# @p_config
# @p_list
#
#
	def __init__(self, description, config_filename):
		self.p_description = description
		self.p_config_filename = config_filename
		self.p_config = ConfigParser.ConfigParser()
		self.p_config.read(self.p_config_filename)
		self.p_list = []

		for section in self.p_config.sections():
			offset = self.p_config.getint(section, 'offset')
			length = self.p_config.getint(section, 'length')
			rstr = self.p_config.get(section, 'string')
			xstr = string.split(rstr, ',')
			bstr = []
			for x in xstr:
				i = string.atoi(x, 16)
				bstr.append(i)
			m = (section, offset, length, bstr)
			print 'HHHHHHHHHHHHHH', m
			self.p_list.append(m)

	def match(self, image, offset, size):
		for m in self.p_list:
			if (offset + m[1] + m[2]) > size:
				return None
			bstr = m[3]
			for i in range(offset + m[1], offset + m[1] + m[2]):
				if image[i] != bstr[i - offset - m[1]]:
					return None
		print 'MATCH', self.p_description
		return 1

class PrologueParser:
#
# @p_config_filename
# @p_config
# @p_list = []
#
#
	def __init__(self, config_filename="../etc/Prologue.config"):
		self.p_config_filename = config_filename
		self.p_config = ConfigParser.ConfigParser()
		self.p_config.read(self.p_config_filename)
		self.p_list = []

		print 'SECTIONS', self.p_config.sections()
		for section in self.p_config.sections():
			description = self.p_config.get(section, 'description')
			filename = self.p_config.get(section, 'config')
			prologue = Prologue(description, 'etc/' + filename)
			print 'FILE', description, filename
			self.p_list.append(prologue)

	def run(self, filename):
		stat = os.stat(filename)
		size = stat[ST_SIZE]
		f = open(filename, "rb")
		image = array('B')
		image.fromfile(f, size)
		for i in range(0, size):
			for p in self.p_list:
				p.match(image, i, size)
		f.close()
		return
