#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

struct storage_s {
	int		fd;
	char*		filename;
	struct stat	st;
};

static int
process(struct storage_s *s)
{
	int i;
	for (i = 0; i < 10; i++) {
		printf("%s\n", s->filename);
		printf("%i\n", s->st.st_size);
	}
	printf("%i\n", s->fd);
	return 0;
}

int
main(int argc, char *argv[])
{
	struct storage_s s;
	int ret;

	if (argc != 2) exit(1);
	if ((s.filename = strdup(argv[1])) == NULL) exit(1);
	if ((s.fd = open(s.filename, O_RDONLY)) == -1) exit(1);
	if (fstat(s.fd, &s.st) != 0) exit(1);
	ret = process(&s);
	exit(0);
}
