#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

struct details_s {
	int		fd;
	struct stat	st;
};

struct storage_s {
	char*			filename;
	struct details_s	d;
};

static int
process(struct storage_s *s)
{
	printf("%s\n", s->filename);
	printf("%i\n", s->d.st.st_size);
	return 0;
}

int
main(int argc, char *argv[])
{
	struct storage_s s;
	int ret;

	if (argc != 2) exit(1);
	if ((s.filename = strdup(argv[1])) == NULL) exit(1);
	if ((s.d.fd = open(s.filename, O_RDONLY)) == -1) exit(1);
	if (fstat(s.d.fd, &s.d.st) != 0) exit(1);
	ret = process(&s);
	exit(0);
}
