#ifndef ZILVIOTHREADS_H
#define ZILVIOTHREADS_H

#include "machine.h"
#include "internal.h"
#include "ZilvioTHREADS_semaphore2.h"
#include <signal.h>
#include <sys/time.h>

typedef int ZTpthread_t;

enum {
	PTHREAD_CREATE_JOINABLE,
	PTHREAD_CREATE_DETACHED
};

int	ZTpthread_attr_init(ZTpthread_attr_t *attr);
int	ZTpthread_attr_destroy(ZTpthread_attr_t *attr);
int	ZTpthread_attr_setdetachstate(ZTpthread_attr_t *attr, int);
int	ZTpthread_attr_getdetachstate(const ZTpthread_attr_t *, int *);
int	ZTpthread_attr_setstackaddr(ZTpthread_attr_t *attr, void *);
int	ZTpthread_attr_getstackaddr(const ZTpthread_attr_t *attr, void **);
int	ZTpthread_attr_setstacksize(ZTpthread_attr_t *attr, size_t);
int	ZTpthread_attr_getstacksize(const ZTpthread_attr_t *, size_t *);

int	ZTpthread_once(ZTpthread_once_t *, void (*)(void));

typedef void *(*pthread_fn_t)(void *);

int	ZTpthread_create(ZTpthread_t *, const ZTpthread_attr_t *, pthread_fn_t,
		void *);
int	ZTpthread_join(ZTpthread_t, void **);
void	ZTpthread_exit(void *);
int	ZTpthread_detach(ZTpthread_t);

int		ZTpthread_equal(ZTpthread_t, ZTpthread_t);
ZTpthread_t	ZTpthread_self(void);

int	pthread_yield_np(void);

int	ZTpthread_mutexattr_init(ZTpthread_mutexattr_t *);
int	ZTpthread_mutexattr_destroy(ZTpthread_mutexattr_t *);
int	ZTpthread_mutexattr_settype(ZTpthread_mutexattr_t *, int);

int	ZTpthread_mutex_init(ZTpthread_mutex_t *,
		const ZTpthread_mutexattr_t *);
int	ZTpthread_mutex_destroy(ZTpthread_mutex_t *mutex);
int	ZTpthread_mutex_lock(ZTpthread_mutex_t *mutex);
int	ZTpthread_mutex_trylock(ZTpthread_mutex_t *mutex);
int	ZTpthread_mutex_unlock(ZTpthread_mutex_t *mutex);

int	ZTpthread_cond_init(ZTpthread_cond_t *, const ZTpthread_condattr_t *);
int	ZTpthread_cond_timedwait(ZTpthread_cond_t *, ZTpthread_mutex_t *,
  	      struct timespec *);
int	ZTpthread_cond_destroy(ZTpthread_cond_t *condition);
int	ZTpthread_cond_wait(ZTpthread_cond_t *, ZTpthread_mutex_t *);
int	ZTpthread_cond_signal(ZTpthread_cond_t *condition);
int	ZTpthread_cond_broadcast(ZTpthread_cond_t *condition);

int	ZTpthread_rwlock_init(ZTpthread_rwlock_t *,
		const ZTpthread_rwlockattr_t *);
int	ZTpthread_rwlock_destroy(ZTpthread_rwlock_t *);
int	ZTpthread_rwlock_rdlock(ZTpthread_rwlock_t *);
int	ZTpthread_rwlock_tryrdlock(ZTpthread_rwlock_t *);
int	ZTpthread_rwlock_wrlock(ZTpthread_rwlock_t *);
int	ZTpthread_rwlock_trywrlock(ZTpthread_rwlock_t *);
int	ZTpthread_rwlock_unlock(ZTpthread_rwlock_t *);

enum {
	PTHREAD_CANCEL_ENABLE,
	PTHREAD_CANCEL_DISABLE
};

enum {
	PTHREAD_CANCEL_DEFERRED,
	PTHREAD_CANCEL_ASYNCHRONOUS
};

#define PTHREAD_CANCELED ((void *)-1)

int	ZTpthread_cancel(ZTpthread_t th);
int	ZTpthread_setcancelstate(int state, int *oldstate);
int	ZTpthread_setcanceltype(int type, int *oldtype);
void	ZTpthread_testcancel(void);
 
int	ZTpthread_sigmask(int how, const sigset_t *newmask, sigset_t *oldmask);
int	ZTpthread_kill(ZTpthread_t th, int signo);

#ifdef _PTHREADS_COMPATABLE

typedef ZTpthread_t pthread_t;
typedef ZTpthread_mutex_t pthread_mutex_t;
typedef ZTpthread_cond_t pthread_cond_t;
typedef ZTpthread_rwlock_t pthread_rwlock_t;

weak_alias(ZTpthread_attr_init, pthread_attr_init);
weak_alias(ZTpthread_attr_destroy, pthread_attr_destroy);
weak_alias(ZTpthread_attr_setdetachstate, pthread_attr_setdetachstate);
weak_alias(ZTpthread_attr_getdetachstate, pthread_attr_getdetachstate);
weak_alias(ZTpthread_attr_setstackaddr, pthread_attr_setstackaddr);
weak_alias(ZTpthread_attr_getstackaddr, pthread_attr_getstackaddr);
weak_alias(ZTpthread_attr_setstacksize, pthread_attr_setstacksize);
weak_alias(ZTpthread_attr_getstacksize, pthread_getstacksize);

weak_alias(ZTpthread_once, pthread_once);

weak_alias(ZTpthread_create, pthread_create);
weak_alias(ZTpthread_join, pthread_join);
weak_alias(ZTpthread_exit, pthread_exit);
weak_alias(ZTpthread_detach, pthread_detach);

weak_alias(ZTpthread_equal, pthread_equal);
weak_alias(ZTpthread_self, pthread_self);

weak_alias(ZTpthread_mutexattr_init, pthread_mutexattr_init);
weak_alias(ZTpthread_mutexattr_destroy, pthread_mutexattr_destroy);
weak_alias(ZTpthread_mutexattr_settype, pthread_mutexattr_settype);

weak_alias(ZTpthread_mutex_init, pthread_mutex_init);
weak_alias(ZTpthread_mutex_destroy, pthread_mutex_destroy);
weak_alias(ZTpthread_mutex_lock, pthread_mutex_lock);
weak_alias(ZTpthread_mutex_trylock, pthread_mutex_trylock);
weak_alias(ZTpthread_mutex_unlock, pthread_mutex_unlock);

weak_alias(ZTpthread_cond_init, pthread_cond_init);
weak_alias(ZTpthread_cond_timedwait, pthread_cond_timedwait);
weak_alias(ZTpthread_cond_destroy, pthread_cond_destroy);
weak_alias(ZTpthread_cond_wait, pthread_cond_wait);
weak_alias(ZTpthread_cond_signal, pthread_cond_signal);
weak_alias(ZTpthread_cond_broadcast, pthread_cond_broadcast);

weak_alias(ZTpthread_rwlock_init, pthread_rwlock_init);
weak_alias(ZTpthread_rwlock_destroy, pthread_rwlock_destroy);
weak_alias(ZTpthread_rwlock_rdlock, pthread_rwlock_rdlock);
weak_alias(ZTpthread_rwlock_tryrdlock, pthread_rwlock_tryrdlock);
weak_alias(ZTpthread_rwlock_wrlock, pthread_rwlock_wrlock);
weak_alias(ZTpthread_rwlock_trywrlock, pthread_rwlock_trylock);
weak_alias(ZTpthread_rwlock_unlock, pthread_rwlock_unlock);

weak_alias(ZTpthread_cancel, pthread_cancel);
weak_alias(ZTpthread_setcancelstate, pthread_setcancelstate);
weak_alias(ZTpthread_setcanceltype, pthread_setcanceltype);
weak_alias(ZTpthread_testcancel, pthread_testcancel);
 
weak_alias(ZTpthread_sigmask, pthread_sigmask);
weak_alias(ZTpthread_kill, pthread_kill);

weak_alias(ZTsem_init, sem_init);
weak_alias(ZTsem_destroy, sem_destroy);
weak_alias(ZTsem_post, sem_post);
weak_alias(ZTsem_wait, sem_wait);

#endif

#endif
