#include "internal.h"
#include "wait.h"
#include "context.h"
#include "manager.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <setjmp.h>
#include <assert.h>
#include <errno.h>
#include <sys/mman.h>

int
ZTpthread_attr_init(ZTpthread_attr_t *attr)
{
	attr->stack		= NULL;
	attr->stack_size	= PTHREAD_STACK_SIZE;
	attr->detached		= 0;
	return 0;
}

int
ZTpthread_attr_destroy(ZTpthread_attr_t *attr)
{
	return 0;
}

int
ZTpthread_attr_setdetachstate(ZTpthread_attr_t *attr, int detachstate)
{
	if (detachstate != PTHREAD_CREATE_DETACHED &&
		detachstate != PTHREAD_CREATE_JOINABLE
	) return -EINVAL;
	attr->detached = detachstate;
	return 0;
}

int
ZTpthread_attr_getdetachstate(const ZTpthread_attr_t *attr, int *detachstate)
{
	*detachstate = attr->detached != 0 ? PTHREAD_CREATE_DETACHED :
		PTHREAD_CREATE_JOINABLE;
	return 0;
}

int
ZTpthread_attr_setstacksize(ZTpthread_attr_t *attr, size_t stacksize)
{
	attr->stack_size = stacksize;
	return 0;
}

int
ZTpthread_attr_getstacksize(const ZTpthread_attr_t *attr, size_t *stacksize)
{
	*stacksize = attr->stack_size;
	return 0;
}

int
ZTpthread_attr_setstackaddr(ZTpthread_attr_t *attr, void *addr)
{
abort(); /* FIXME */
	attr->stack = addr;
	return 0;
}

int
ZTpthread_attr_getstackaddr(const ZTpthread_attr_t *attr, void **addr)
{
	*addr = attr->stack;
	return 0;
}

int
ZTpthread_detach(ZTpthread_t th)
{
	ZilvioTHREAD_t *t;

	t = (ZilvioTHREAD_t *)th;
	if (t->detached != 0) return -EINVAL;
	t->detached = 1;
	return 0;
}
