#include "internal.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <errno.h>

int
ZTpthread_cancel(ZTpthread_t th)
{
	ZilvioTHREAD_t *t;

	t = (ZilvioTHREAD_t *)th;
	t->cancel = 1;
	return 0;
}

int
ZTpthread_setcancelstate(int state, int *oldstate)
{
	if (state != PTHREAD_CANCEL_ENABLE && state != PTHREAD_CANCEL_DISABLE)
		return -EINVAL;
	if (oldstate != NULL) *oldstate = current->cancelstate;
	current->cancelstate = state;
	return 0;
}

int
ZTpthread_setcanceltype(int type, int *oldtype)
{
	if (type != PTHREAD_CANCEL_DEFERRED &&
		type != PTHREAD_CANCEL_ASYNCHRONOUS
	)
		return -EINVAL;
	if (oldtype != NULL) *oldtype = current->canceltype;
	current->canceltype = type;
	return 0;
}

void
ZTpthread_testcancel(void)
{
	if (current->cancel) ZTpthread_exit(PTHREAD_CANCELED);
}
