#include "internal.h"
#include "wait.h"
#include "spinlock.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <assert.h>

int
ZTpthread_cond_init(ZTpthread_cond_t *condition,
	const ZTpthread_condattr_t *attr)
{
	ZilvioTHREAD_waitqueue_init(&condition->waiting);
	spinlock_init(&condition->spinlock);
	return 0;
}

int
ZTpthread_cond_destroy(ZTpthread_cond_t *condition)
{
	ZilvioTHREAD_waitqueue_cleanup(&condition->waiting);
	spinlock_cleanup(&condition->spinlock);
	return 0;
}

int
ZTpthread_cond_timedwait(ZTpthread_cond_t *condition, ZTpthread_mutex_t *mutex,
	struct timespec *abstime)
{
	return ZTpthread_cond_wait(condition, mutex);
}

int
ZTpthread_cond_wait(ZTpthread_cond_t *condition, ZTpthread_mutex_t *mutex)
{
pthread_yield_np();
	spinlock_lock(&condition->spinlock);
	spinlock_lock(&running_queue_spinlock);
	ZilvioTHREAD_wait(&current, &condition->waiting);
	running_queue_size--;
	spinlock_unlock(&running_queue_spinlock);
	spinlock_unlock(&condition->spinlock);
spinlock_lock(&mutex->spinlock);
mutex->count--;
spinlock_unlock(&mutex->spinlock);
//pthread_mutex_unlock(mutex);
	pthread_yield_np();
	ZTpthread_mutex_lock(mutex);
	return 0;
}

int
ZTpthread_cond_signal(ZTpthread_cond_t *condition)
{
	assert(condition != NULL);
	
pthread_yield_np();
	spinlock_lock(&condition->spinlock);
	if (condition->waiting != NULL) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wakeup_one(&condition->waiting);
		running_queue_size++;
		spinlock_unlock(&running_queue_spinlock);
		printf("now is %p\n", condition->waiting);
		spinlock_unlock(&condition->spinlock);
		pthread_yield_np();
		return 0;
	}
	spinlock_unlock(&condition->spinlock);
	return 0;
}

int
ZTpthread_cond_broadcast(ZTpthread_cond_t *condition)
{
	size_t n;

pthread_yield_np();
	spinlock_lock(&condition->spinlock);
	if (condition->waiting != NULL) {
		spinlock_lock(&running_queue_spinlock);
		n = ZilvioTHREAD_wakeup_all(&condition->waiting);
		running_queue_size += n;
		spinlock_unlock(&running_queue_spinlock);
	}
	spinlock_unlock(&condition->spinlock);
	return 0;
}
