#include "internal.h"
#include "context.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <sys/mman.h>
#include <errno.h>

static void
__run(void *(*fn)(void *), void *arg)
{
	pthread_exit(fn(arg));
}
 
ZilvioTHREAD_t*
ZilvioTHREAD_context_init(size_t stack_size, void *(*fn)(void *), void *arg)
{
	void *p;
	int *bottom_of_stack;
	ZilvioTHREAD_t *t;

	p = mmap(NULL, stack_size, PROT_READ | PROT_WRITE | PROT_EXEC,
		MAP_PRIVATE | MAP_ANON, -1, 0);
	if (p == (void *)-1) {
printf("errno %i\n", errno);
return NULL;
}
 
#if 1
	bottom_of_stack = (int *)
		((char *)p + stack_size - sizeof(ZilvioTHREAD_t));
	t = (ZilvioTHREAD_t *)bottom_of_stack;
	bottom_of_stack--;
	*bottom_of_stack-- = (int)arg;
	*bottom_of_stack-- = (int)fn;
#else
	t = (ZilvioTHREAD_t *)p;
	bottom_of_stack = (int *)((char *)p + sizeof(ZilvioTHREAD_t));
	bottom_of_stack++;
	*bottom_of_stack++ = (int)arg;
	*bottom_of_stack++ = (int)fn;
#endif
	sigsetjmp(t->context.state, 1);
	t->context.stack = (int *)p;
	t->context.stack_size = stack_size;
	t->context.state[0].__jmpbuf[JB_PC] = (int)__run;
	t->context.state[0].__jmpbuf[JB_SP] = (int)bottom_of_stack;
	t->context.state[0].__jmpbuf[JB_BP] = 0;
 	return t;
}

void
ZilvioTHREAD_context_cleanup(ZilvioTHREAD_context_t *context)
{
	free(context->stack), context->stack = NULL;
}
