#include "internal.h"
#include "wait.h"
#include "context.h"
#include "manager.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <setjmp.h>
#include <assert.h>
#include <errno.h>

void
ZTpthread_exit(void *exitval)
{
	spinlock_lock(&running_queue_spinlock);
	ZilvioTHREAD_wait(&current, &exit_queuep);
	running_queue_size--;
	current->state = THREAD_EXIT1;
	current->exitval = exitval;
	if (current->join != NULL) {
		current->join = ZilvioTHREAD_wakeup(&current->join);
		running_queue_size++;
	}
	current->exitval = exitval;
	spinlock_unlock(&running_queue_spinlock);
	pthread_yield_np();
}

int
ZTpthread_join(ZTpthread_t th, void **exitval)
{
	ZilvioTHREAD_t *t;

	t = (ZilvioTHREAD_t *)th;
	spinlock_lock(&running_queue_spinlock);
	if (current == t) {
		spinlock_unlock(&running_queue_spinlock);
		return -EDEADLK;
	}
	if (t->join != NULL) {
		spinlock_unlock(&running_queue_spinlock);
		return -EINVAL;
	}
	if (t->state == THREAD_EXIT1) goto here;
	t->join = current;
	ZilvioTHREAD_wait(&current, &join_queuep);
	running_queue_size--;
	spinlock_unlock(&running_queue_spinlock);
	pthread_yield_np();
	spinlock_lock(&running_queue_spinlock);
here:
	if (exitval != NULL) *exitval = t->exitval;
	spinlock_unlock(&running_queue_spinlock);
	return 0;
}
