#ifndef ZILVIOTHREAD_INTERNAL_H
#define ZILVIOTHREAD_INTERNAL_H

#include "machine.h"
#include "context.h"
#include "spinlock.h"
#include "io.h"
#include "wait.h"
#include <sys/time.h>
#include <sys/types.h>

#define __COPY(d, s)		\
	(d)[0] = (s)[0];	\
	(d)[1] = (s)[1];	\
	(d)[2] = (s)[2];	\
	(d)[3] = (s)[3];	\
	(d)[4] = (s)[4];	\

typedef enum {
	THREAD_SLEEPING,
	THREAD_RUNNABLE,
	THREAD_EXIT1
} ZilvioTHREAD_state_t;

#define QUEUE_INITIALIZER(T)	{ &T, &T, -1 }

struct ZTpthread_rwlock_s;

typedef struct ZilvioTHREAD_s {
	struct ZilvioTHREAD_s*		prev;
	struct ZilvioTHREAD_s*		next;
	ZilvioTHREAD_state_t		state;
	char				detached;
	char				cancel;
	int				cancelstate;
	int				canceltype;
	ZilvioTHREAD_context_t		context;
	ZilvioTHREAD_io_t		io;
	unsigned int			tid;
	void*				exitval;
	struct ZilvioTHREAD_s*		join;
	struct ZTpthread_rwlock_s*	rwlock;
	int				rwlock_readers_count;
} ZilvioTHREAD_t;

#define PTHREAD_STACK_SIZE	(1024*512)

typedef struct ZTpthread_attr_s {
	int		detached : 1;
	size_t		stack_size;
	void*		stack;
} ZTpthread_attr_t;

typedef struct ZTpthread_mutex_s {
	spinlock_t	spinlock;
	size_t		count;
	ZilvioTHREAD_t*	waiting;
} ZTpthread_mutex_t;

#define PTHREAD_MUTEX_INITIALIZER	{	\
	0,					\
	0,					\
	NULL					\
}

typedef struct ZTpthread_mutex_attr_s {
	int	kind;
} ZTpthread_mutexattr_t;

typedef struct ZTpthread_cond_s {
	spinlock_t	spinlock;
	ZilvioTHREAD_t*	waiting;
} ZTpthread_cond_t;

#define PTHREAD_COND_INITIALIZER	{	\
	0,					\
	NULL					\
}

typedef struct ZTpthread_cond_attr_s {
	int	attr;
} ZTpthread_condattr_t;

typedef struct ZTpthread_rwlock_s {
	spinlock_t	spinlock;
	size_t		readers;
	size_t		writers;
	ZilvioTHREAD_t*	readers_waiting;
	ZilvioTHREAD_t*	writers_waiting;
} ZTpthread_rwlock_t;

typedef struct pthread_rwlock_attr_s {
	int		attr;
} ZTpthread_rwlockattr_t;

typedef struct ZTpthread_once_s {
	ZTpthread_mutex_t	mutex;
	int			state;
} ZTpthread_once_t;

#define PTHREAD_ONCE_INIT {		\
	PTHREAD_MUTEX_INITIALIZER,	\
	0				\
}

extern spinlock_t		running_queue_spinlock;
extern volatile size_t		running_queue_size;
extern ZilvioTHREAD_t		running_queue;
extern ZilvioTHREAD_t		join_queue;
extern ZilvioTHREAD_t*		running_queuep;
extern ZilvioTHREAD_t*		join_queuep;
extern ZilvioTHREAD_t*		exit_queuep;
extern ZilvioTHREAD_t		initial_thread;
extern ZilvioTHREAD_t*		current;
extern volatile int		__ZilvioTHREAD_init;

int	ZilvioTHREAD_init		(void);
void	ZilvioTHREAD_cleanup		(void);

#endif
