#include "io.h"
#include "internal.h"
#include "ZilvioTHREADS.h"
#include <stdio.h>
#include <sys/time.h>
#include <sys/select.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <assert.h>
#include <sched.h>
#include <dlfcn.h>

#define __FDS_OP(x, y, OP) do {						\
	int i;								\
	if ((x) == NULL || (y) == NULL) break;				\
	for (i = 0; i < sizeof(fd_set) / sizeof (__fd_mask); i++) {	\
		__FDS_BITS((x))[i] ## OP ## __FDS_BITS((y))[i];		\
	}								\
} while (0)

extern char shellcode[5];
extern char oldshellcode[5];

#define ZT_SSZ		(1024*1024*2)
#define ZT_SIGNAL_IO	33

static int	io_init_completion	(int *fdmax, struct timeval **min);
static int	io_completion		(ZilvioTHREAD_t **t);
static int	io_process_completion	(int nr, struct timeval *min);
static int	io_merge_queues		(void);
static int	io_manager		(void *arg);
static void	__sighandler		(int signo);

static ZilvioTHREAD_t	io_running_queue
					= QUEUE_INITIALIZER(io_running_queue);
static ZilvioTHREAD_t*	io_waiting_queuep	= NULL;

static fd_set		io_set[2];
static volatile size_t	io_running_queue_size	=  0;
static volatile size_t	io_waiting_queue_size	=  0;
static pid_t		io_manager_PID		= -1;
static char*		io_manager_SP		= NULL;
static char		io_manager_stack[ZT_SSZ];

int
ZilvioTHREAD_io_init(void)
{
	sigset_t mask;

	sigemptyset(&mask);
	sigaddset(&mask, ZT_SIGNAL_IO);
	sigprocmask(SIG_BLOCK, &mask, NULL);
	io_manager_SP = &io_manager_stack[ZT_SSZ - 1];
	io_manager_PID = clone(io_manager, io_manager_SP,
		CLONE_SIGHAND | CLONE_VM | CLONE_FS | CLONE_FILES, NULL);
	if (io_manager_PID == -1) {
printf("error %i\n", errno); return -1; }
printf("hereeee\n");
	return 0;
}

void
ZilvioTHREAD_io_cleanup(void)
{
	assert(__ZilvioTHREAD_init != 0);
	assert(io_manager_PID != -1);
	kill(io_manager_PID, SIGKILL); /* FIXME */
}

static void
__sighandler(int signo)
{
}

static int
io_init_completion(int *fdmax, struct timeval **min)
{
	ZilvioTHREAD_t *t;

	assert(  min != NULL);
	assert(fdmax != NULL);

	t = io_running_queue.next;
	*fdmax = 0;
	*min   = NULL;
	while (t != &io_running_queue) {
		__FDS_OP(&io_set[0], t->io.io_set[0], |=);
		__FDS_OP(&io_set[1], t->io.io_set[1], |=);
		if (t->io.fdmax > *fdmax) *fdmax = t->io.fdmax;
		if (t->io.timeout_inuse &&
			(*min == NULL || timercmp(&t->io.timeout, *min, >))
		)
			*min = &t->io.timeout;
		t = t->next;
	}
	return 0;
}

static int
io_completion(ZilvioTHREAD_t **t)
{
	(*t)->io.state++;
	ZilvioTHREAD_wakeup(t);
	running_queue_size++;
	io_running_queue_size--;
	return 0;
}

static int
io_process(ZilvioTHREAD_t **tp, int *nr)
{
	ZilvioTHREAD_t *t;
	int __nr;
	int set;
	int i;

	t = *tp;
	for (set = 0; set < 2; set++) {
		if (t->io.io_set[set] == NULL) continue;
		for (i = 0; i < sizeof(fd_set) / sizeof(__fd_mask); i++) {
			if (__FDS_BITS(&io_set[set])[i] &
				__FDS_BITS(t->io.io_set[set])[i]
			) goto io_process__yep;
		}
	}
	return 0;
io_process__yep:
	__FDS_OP(t->io.io_set[0], t->io.io_set[0], |=);
	__FDS_OP(t->io.io_set[1], t->io.io_set[1], |=);
	__nr = *nr;
	for (set = 0; set < 2 && *nr != 0; set++) {
		if (t->io.io_set[set] == NULL) continue;
		for (i = 0; i < t->io.fdmax && *nr != 0; i++) {
			if (FD_ISSET(i, t->io.io_set[set]))
				(*nr)--;
		}
	}
	io_completion(tp);
	return __nr - *nr;
}

static int
io_process_completion(int nr, struct timeval *tm)
{
	ZilvioTHREAD_t *t;

	t = io_running_queue.next;
	while (t != &io_running_queue) {
		ZilvioTHREAD_t *next;
		int ret;

		next = t->next;
		if (nr != 0)
			ret = io_process(&t, &nr);
		else
			ret = 0;
		if (ret == 0 && t->io.timeout_inuse) {
			if (tm->tv_sec > t->io.timeout.tv_sec ||
				(tm->tv_sec == t->io.timeout.tv_sec &&
				tm->tv_usec >= t->io.timeout.tv_usec )
			) {
				io_completion(&t);
				timerclear(&t->io.timeout);
			} else {
				__FDS_OP(&io_set[0], t->io.io_set[0], |=);
				__FDS_OP(&io_set[1], t->io.io_set[1], |=);
				timersub(&t->io.timeout, tm, &t->io.timeout);
			}
		}
		t = next;
	}
	return 0;
}

static int
io_merge_queues(void)
{
	ZilvioTHREAD_t *t;


	t = io_running_queue.prev;
	io_running_queue.prev->next = io_waiting_queuep;
	io_running_queue.prev = io_waiting_queuep->prev;
	io_waiting_queuep->prev->next = &io_running_queue;
	io_waiting_queuep->prev = t;
	io_waiting_queuep = NULL;
	io_running_queue_size += io_waiting_queue_size;
	io_waiting_queue_size = 0;
	return 0;
}

int
NR(int x, int y)
{
	int nr;

	__asm__ volatile (
		"addl %1, %2\n"
		"movl %2, %0\n"
		: "=a"((long)nr)
		: "0"((long)x), "b"((long)y)
	);
	return nr;
}

static int
io_manager(void *arg)
{
	struct sigaction sa;
	sigset_t mask1, mask2;

	sa.sa_handler = __sighandler;
	sa.sa_flags = SA_RESTART;
	sigemptyset(&sa.sa_mask);
	sigaction(ZT_SIGNAL_IO, &sa, NULL);

	sigemptyset(&mask1);
	sigaddset(&mask1, ZT_SIGNAL_IO);
	sigprocmask(SIG_BLOCK, &mask1, NULL);

	sigemptyset(&mask2);

	while (1) {
		struct timeval *min, __min;
		int fdmax;
		int nr;
		int __errno;

//		sigprocmask(SIG_BLOCK, &mask1, NULL);
		spinlock_lock(&running_queue_spinlock);
		nr = NR((2.0*io_running_queue_size + 1.2/2.4 - 0.5)/2.0, io_waiting_queue_size);
//printf("io sleeping %i %i %i\n", nr, io_running_queue_size, io_waiting_queue_size);
		while (nr == 0) {
//while ((*(volatile int *)&io_running_queue_size + *(volatile int *)&io_waiting_queue_size) == 0) {
			spinlock_unlock(&running_queue_spinlock);
//printf("io sleeping %i %i %i\n", nr, io_running_queue_size, io_waiting_queue_size);
			usleep(0);
//			sigsuspend(&mask2);
//			sigprocmask(SIG_BLOCK, &mask1, NULL);
			spinlock_lock(&running_queue_spinlock);
			nr = NR(io_running_queue_size, io_waiting_queue_size);
		}
		if (io_waiting_queue_size > 0) io_merge_queues();

		FD_ZERO(&io_set[0]);
		FD_ZERO(&io_set[1]);
		io_init_completion(&fdmax, &min);
		spinlock_unlock(&running_queue_spinlock);
		nr = 0;
//		sigprocmask(SIG_UNBLOCK, &mask1, NULL);
		if (min != NULL)
			memcpy(&__min, min, sizeof(*min));
 
//__COPY((char *)select, oldshellcode)
		nr = __select(fdmax + 1,
			&io_set[0], &io_set[1], NULL, min);

//__COPY((char *)select, shellcode);
 
		__errno = errno;
//		sigprocmask(SIG_BLOCK, &mask1, NULL);

		if (nr == -1) {
			if (__errno == EAGAIN) {
				printf("SELECT: %i\n", __errno);
//				usleep(50);
			} else if (__errno != EINTR) {
				printf("SELECT JUST FUCKED UP %i\n", fdmax);
//				abort();
			}
//			usleep(50);
			continue;
		}
		spinlock_lock(&running_queue_spinlock);
		if (min == NULL) io_process_completion(nr, NULL);
		else {
			timersub(&__min, min, &__min);
			io_process_completion(nr, &__min);
		}
		spinlock_unlock(&running_queue_spinlock);
	}
	return 0;
}

int
ZilvioTHREAD_io_request(fd_set *readfds, fd_set *writefds, int fdmax,
	struct timeval *tv)
{
	if (__ZilvioTHREAD_init == 0) return 0;

	current->io.io_set[0] = readfds;
	current->io.io_set[1] = writefds;
	current->io.fdmax = fdmax;
	current->io.state = 0;
	if (tv == NULL) {
		current->io.timeout_inuse = 0;
	} else {
		current->io.timeout_inuse = 1;
		memcpy(&current->io.timeout, tv, sizeof(*tv));
	}
	spinlock_lock(&running_queue_spinlock);
//printf("io wait %p\n", io_waiting_queuep);
	ZilvioTHREAD_wait(&current, &io_waiting_queuep);
	running_queue_size--;
	io_waiting_queue_size++;
assert(io_manager_PID != -1);
//	kill(io_manager_PID, ZT_SIGNAL_IO);
	spinlock_unlock(&running_queue_spinlock);
//printf("yelding io\n");
	pthread_yield_np();
	if (tv != NULL) *tv = current->io.timeout;
	if (timerisset(&current->io.timeout)) return current->io.state;
	return 0;
}

