#include "machine.h"

int
testandset(spinlock_t *spinlock)
{
	int ret;

	__asm__ __volatile__(
		"xchgl %0, %1"
		: "=r"(ret), "=m"(*spinlock)
		: "0"(1), "m"(*spinlock)
		: "memory"
	);
	return ret;
}

void
swap_atomic(volatile int *x, volatile int *y)
{
	__asm__ __volatile__(
		"xchgl %0, %1"
		: "=r"(x), "=m"(*y)
		: "0"(*x), "m"(*y)
		: "memory"
	);
}

void
unset(spinlock_t *spinlock)
{
	__asm__ __volatile__(
		"movl $0, %0"
		: "=m"(*spinlock)
		:
		: "memory"
	);
}
