#ifndef MACHINE_H
#define MACHINE_H

#define weak_alias(name, aliasname) \
	extern __typeof(name) aliasname __attribute__((weak, alias(#name)))

#define strong_alias(name, aliasname) \
	extern __typeof(name) aliasname __attribute__((alias(#name)))

typedef volatile int spinlock_t;

#define STORE_BARRIER()
#define READ_BARRIER()
#define MEMORY_BARRIER()

int	testandset	(spinlock_t *spinlock);
void	swap_atoimic	(volatile int *x, volatile int *y);
void	unset		(spinlock_t *spinlock);

#endif
