#include "internal.h"
#include "wait.h"
#include "spinlock.h"
#include "ZilvioTHREADS.h"
#include <errno.h>
#include <assert.h>
#include <stdio.h>

int
ZTpthread_mutexattr_init(ZTpthread_mutexattr_t *attr)
{
	return 0;
}

int
ZTpthread_mutexattr_destroy(ZTpthread_mutexattr_t *attr)
{
	return 0;
}

int
ZTpthread_mutexattr_settype(ZTpthread_mutexattr_t *attr, int kind)
{
	attr->kind = kind;
	return 0;
}

int
ZTpthread_mutex_init(ZTpthread_mutex_t *mutex,
	const ZTpthread_mutexattr_t *attr)
{
	ZilvioTHREAD_waitqueue_init(&mutex->waiting);
	spinlock_init(&mutex->spinlock);
	mutex->count = 0;
	return 0;
}

int
ZTpthread_mutex_destroy(ZTpthread_mutex_t *mutex)
{
	if (mutex->count != 0) return -EBUSY;
	spinlock_cleanup(&mutex->spinlock);
	ZilvioTHREAD_waitqueue_cleanup(&mutex->waiting);
	return 0;
}

int
ZTpthread_mutex_lock(ZTpthread_mutex_t *mutex)
{
/* Loop for spurious wakeups - though, this should never happen. */
pthread_yield_np();
	spinlock_lock(&mutex->spinlock);
	while (mutex->count != 0) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wait(&current, &mutex->waiting);
printf("did wait 4 mutex\n");
		running_queue_size--;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&mutex->spinlock);
		pthread_yield_np();
		spinlock_lock(&mutex->spinlock);
	}
	mutex->count++;
	spinlock_unlock(&mutex->spinlock);
	return 0;
}

int
ZTpthread_mutex_trylock(ZTpthread_mutex_t *mutex)
{
pthread_yield_np();
	spinlock_lock(&mutex->spinlock);
	if (mutex->count == 0) {
		mutex->count++;
		spinlock_unlock(&mutex->spinlock);
		return 0;
	}
	spinlock_unlock(&mutex->spinlock);
	return -EBUSY;
}

int
ZTpthread_mutex_unlock(ZTpthread_mutex_t *mutex)
{
pthread_yield_np();
	spinlock_lock(&mutex->spinlock);
	mutex->count--;
	if (mutex->waiting != NULL) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wakeup_one(&mutex->waiting);
		running_queue_size++;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&mutex->spinlock);
		pthread_yield_np(); /* FIXME ? */
		return 0;
	}
	spinlock_unlock(&mutex->spinlock);
	return 0;
}
