#include "internal.h"
#include "io.h"
#include "ZilvioTHREADS.h"
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>

#define ZT_FDS_INIT(sock, set, type) do	{				\
	FD_ZERO(&(set)[0]);						\
	FD_ZERO(&(set)[1]);						\
	FD_SET((sock), &(set)[(type)]);					\
} while (0)

extern char shellcode[5];
extern char oldshellcode[5];

int __libc_accept(int, struct sockaddr *, socklen_t *);
int
accept(int sock, struct sockaddr *addr, socklen_t *addrlen)
{
	fd_set io_set[2];						\
	int ret;
	int fdflag;

	pthread_yield_np();

	if (sock == -1) return EBADF;

	fdflag = fcntl(sock, F_GETFL, 0);
	if (fdflag & O_NONBLOCK) return __libc_accept(sock, addr, addrlen);
	fcntl(sock, F_SETFL, fdflag | O_NONBLOCK);

	ZT_FDS_INIT(sock, io_set, 0);
	ZilvioTHREAD_io_request(&io_set[0], &io_set[1], sock + 1, NULL);
	ret = __libc_accept(sock, addr, addrlen);
	fcntl(sock, F_SETFL, fdflag);
	return ret;
	
}

int __libc_connect(int, const struct sockaddr *, socklen_t);
int
connect(int sock, const struct sockaddr *addr, socklen_t addrlen)
{
	int ret;
	int fdflag;

	pthread_yield_np();

	if (sock == -1) return EBADF;

	fdflag = fcntl(sock, F_GETFL, 0);
	if (fdflag & O_NONBLOCK) return __libc_connect(sock, addr, addrlen);
	fcntl(sock, F_SETFL, fdflag | O_NONBLOCK);

	ret = __libc_connect(sock, addr, addrlen);
	if (ret == 0)
		goto ZilvioTHREAD_connect__gotit;
	ret = -1;
	if (errno == EINPROGRESS) {
		int opt;
		size_t optlen = sizeof(opt);
		fd_set io_set[2];

		ZT_FDS_INIT(sock, io_set, 1);
		ZilvioTHREAD_io_request(&io_set[0], &io_set[1], sock + 1,
			NULL);

		getsockopt(sock, SOL_SOCKET, SO_ERROR, &opt, &optlen);
		if (opt == 0) ret = 0;
	}
ZilvioTHREAD_connect__gotit:
	fcntl(sock, F_SETFL, fdflag);
	return ret;
}

int
select(int maxfd, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
	struct timeval *timeout)
{
//memcpy((char *)select, oldshellcode, sizeof(shellcode));
	return ZilvioTHREAD_io_request(readfds, writefds, maxfd, timeout);
}

#define ZT_IO_FASTFUNCTION(res_type, type, name1, name,			\
	param_list, params)						\
res_type name1 param_list;						\
res_type								\
name param_list								\
{									\
	fd_set io_set[2];						\
	int fdflag;							\
	ssize_t n;							\
usleep(1000); \
	pthread_yield_np();						\
	if (sock == -1) return EBADF;					\
	fdflag = fcntl(sock, F_GETFL, 0);				\
	if (fdflag & O_NONBLOCK) return name1 params;			\
	fcntl(sock, F_SETFL, fdflag | O_NONBLOCK);			\
	ZT_FDS_INIT(sock, io_set, type);				\
	ZilvioTHREAD_io_request(&io_set[0], &io_set[1], sock + 1,	\
		NULL);							\
	n = name1 params;						\
	fcntl(sock, F_SETFL, fdflag);					\
	return n;							\
}

#define ZT_IO_SLOWFUNCTION(res_type, type, name1, name,			\
	param_list, params)						\
res_type name1 param_list;						\
res_type								\
name param_list								\
{									\
	fd_set io_set[2];						\
	int fdflag;							\
	ssize_t _sz, n;							\
usleep(1000); \
	pthread_yield_np();						\
	if (sock == -1) return EBADF;					\
	fdflag = fcntl(sock, F_GETFL, 0);				\
	if (fdflag & O_NONBLOCK) return name1 params;			\
	fcntl(sock, F_SETFL, fdflag | O_NONBLOCK);			\
        _sz = count;							\
        while (count > 0) {						\
		n = name1 params;					\
                if (n == 0) break;					\
                else if (n == -1) {					\
                        if (errno == EAGAIN) {				\
				ZT_FDS_INIT(sock, io_set, type);	\
				ZilvioTHREAD_io_request(		\
					&io_set[0], &io_set[1],		\
					sock + 1, NULL			\
				);					\
			} else {					\
				fcntl(sock, F_SETFL, fdflag);		\
				return -1;				\
			}						\
                }							\
                buf += n;						\
                count -= n;						\
		pthread_yield_np();					\
        }								\
	fcntl(sock, F_SETFL, fdflag);					\
        return _sz - count;						\
}

ZT_IO_SLOWFUNCTION	(ssize_t, 1, __libc_write, write,
			(int sock, const void *buf, size_t count),
			(sock, buf, count))

ZT_IO_FASTFUNCTION	(ssize_t, 0, __libc_read, read,
			(int sock, void *buf, size_t count),
			(sock, buf, count))

ZT_IO_FASTFUNCTION	(ssize_t, 0, __libc_recv, recv,
			(int sock, void *buf, size_t count, int flags),
			(sock, buf, count, flags));

ZT_IO_SLOWFUNCTION	(ssize_t, 1, __libc_send, send,
			(int sock, const void *buf, size_t count, int flags),
			(sock, buf, count, flags));

ZT_IO_FASTFUNCTION	(ssize_t, 0, __libc_recvfrom, recvfrom,
			(int sock, void *buf, size_t count, int flags,
			 struct sockaddr *from, socklen_t *fromlen),
			(sock, buf, count, flags, from, fromlen));

ZT_IO_SLOWFUNCTION	(ssize_t, 1, __libc_sendto, sendto,
			(int sock, const void *buf, size_t count, int flags,
			 const struct sockaddr *to, socklen_t tolen),
			(sock, buf, count, flags, to, tolen));

#if 0
/*
FIXME:
	glibc2.1 makes __readv/__writev local!
	glibc2.2 doesnt even have a __readv/__writev!
	sendmsg/writev should be slow too
*/
ZT_IO_FASTFUNCTION	(int, 0, __readv, readv,
			(int sock, const struct iovec *vector, int count),
			(sock, vector, count));

ZT_IO_FASTFUNCTION	(int, 1, __writev, writev,
			(int sock, const struct iovec *vector, int count),
			(sock, vector, count));

ZT_IO_FASTFUNCTION	(int, 1, __libc_sendmsg, sendmsg,
			(int sock, const struct msghdr *msg, int flags),
			(sock, msg, flags));
#endif

ZT_IO_FASTFUNCTION	(int, 0, __libc_recvmsg, recvmsg,
			(int sock, struct msghdr *msg, int flags),
			(sock, msg, flags));
