#include "ZilvioTHREADS.h"
#include "internal.h"
#include <errno.h>
#include <assert.h>
#include <stdio.h>

int
ZTpthread_rwlock_init(ZTpthread_rwlock_t *rwlock,
	const ZTpthread_rwlockattr_t *attr)
{
	spinlock_init(&rwlock->spinlock);
	ZilvioTHREAD_waitqueue_init(&rwlock->readers_waiting);
	ZilvioTHREAD_waitqueue_init(&rwlock->writers_waiting);
	rwlock->readers = rwlock->writers = 0;
	return 0;
}

int
ZTpthread_rwlock_destroy(ZTpthread_rwlock_t *rwlock)
{
	spinlock_lock(&rwlock->spinlock);
	if (rwlock->readers != 0 || rwlock->writers != 0) {
		spinlock_lock(&rwlock->spinlock);
		return -EBUSY;
	}
	spinlock_unlock(&rwlock->spinlock);
	spinlock_cleanup(&rwlock->spinlock);
	ZilvioTHREAD_waitqueue_cleanup(&rwlock->readers_waiting);
	ZilvioTHREAD_waitqueue_cleanup(&rwlock->writers_waiting);
	return 0;
}

int
ZTpthread_rwlock_rdlock(ZTpthread_rwlock_t *rwlock)
{	
	if (__ZilvioTHREAD_init == 0) return 0;
	spinlock_lock(&rwlock->spinlock);
	if (current->rwlock == rwlock) {
		rwlock->readers++;
		current->rwlock_readers_count++;
		spinlock_unlock(&rwlock->spinlock);
		return 0;
	}
	while (rwlock->writers != 0 || rwlock->writers_waiting != NULL) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wait(&current, &rwlock->readers_waiting);
		running_queue_size--;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&rwlock->spinlock);
		pthread_yield_np();
		spinlock_lock(&rwlock->spinlock);
	}
	if (current->rwlock == NULL) current->rwlock = rwlock;
	current->rwlock_readers_count++;
	rwlock->readers++;
	spinlock_unlock(&rwlock->spinlock);
	return 0;
}

int
ZTpthread_rwlock_tryrdlock(ZTpthread_rwlock_t *rwlock)
{
	if (__ZilvioTHREAD_init == 0) return 0;
	spinlock_lock(&rwlock->spinlock);
	if (current->rwlock == rwlock) {
		rwlock->readers++;
		current->rwlock_readers_count++;
		spinlock_unlock(&rwlock->spinlock);
		return 0;
	}
	if (rwlock->writers != 0 || rwlock->writers_waiting != NULL) {
		spinlock_unlock(&rwlock->spinlock);
		return -EBUSY;
	}
	else if (current->rwlock == NULL) current->rwlock = rwlock;
	current->rwlock_readers_count++;
	rwlock->readers++;
	spinlock_unlock(&rwlock->spinlock);
	return 0;
}

int
ZTpthread_rwlock_wrlock(ZTpthread_rwlock_t *rwlock)
{
	if (__ZilvioTHREAD_init == 0) return 0;
	spinlock_lock(&rwlock->spinlock);
	while (rwlock->readers != 0 && rwlock->writers_waiting == NULL) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wait(&current, &rwlock->writers_waiting);
		running_queue_size--;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&rwlock->spinlock);
		pthread_yield_np();
		spinlock_lock(&rwlock->spinlock);
	}
	rwlock->writers++;
	spinlock_unlock(&rwlock->spinlock);
	return 0;
}

int
ZTpthread_rwlock_trywrlock(ZTpthread_rwlock_t *rwlock)
{
	if (__ZilvioTHREAD_init == 0) return 0;
	spinlock_lock(&rwlock->spinlock);
	if (rwlock->readers != 0 && rwlock->writers_waiting == NULL) {
		spinlock_unlock(&rwlock->spinlock);
		return -EBUSY;
	}
	rwlock->readers++;
	spinlock_unlock(&rwlock->spinlock);
	return 0;
}

int
ZTpthread_rwlock_unlock(ZTpthread_rwlock_t *rwlock)
{
	if (__ZilvioTHREAD_init == 0) return 0;
	spinlock_lock(&rwlock->spinlock);
	if (rwlock->writers != 0) {
		rwlock->writers--;
		if (rwlock->writers_waiting != NULL) {
			if (rwlock->readers_waiting != NULL) {
				spinlock_unlock(&rwlock->spinlock);
				return 0;
			}
			spinlock_lock(&running_queue_spinlock);
			ZilvioTHREAD_wakeup_one(&rwlock->writers_waiting);
			running_queue_size++;
			spinlock_unlock(&running_queue_spinlock);
			spinlock_unlock(&rwlock->spinlock);
//			pthread_yield_np(); /* FIXME ? */
			return 0;
		}
		if (rwlock->readers_waiting != NULL) {
			spinlock_lock(&running_queue_spinlock);
			running_queue_size += ZilvioTHREAD_wakeup_all(
				&rwlock->readers_waiting);
			spinlock_unlock(&running_queue_spinlock);
			spinlock_unlock(&rwlock->spinlock);
//			pthread_yield_np(); /* FIXME ? */
			return 0;
		}
		spinlock_unlock(&rwlock->spinlock);
		return 0;
	} else {
		if (current->rwlock == rwlock) {
			current->rwlock_readers_count--;
			if (current->rwlock_readers_count == 0) 
				current->rwlock = NULL;
		}
		rwlock->readers--;
		if (rwlock->readers == 0) {
			if (rwlock->writers_waiting != NULL) {
				spinlock_lock(&running_queue_spinlock);
				ZilvioTHREAD_wakeup_one(
					&rwlock->writers_waiting);
				running_queue_size++;
				spinlock_unlock(&running_queue_spinlock);
			}
			spinlock_unlock(&rwlock->spinlock);
//			pthread_yield_np(); /* FIXME ? */
			return 0;
		}
		spinlock_unlock(&rwlock->spinlock);
	}
	return 0;
}
