#include "ZilvioTHREADS_semaphore.h"
#include <stdio.h>
#include <assert.h>

int
ZTsem_init(ZTsem_t *sem, int pshared, unsigned int count)
{
	ZilvioTHREAD_waitqueue_init(&sem->waiting);
	spinlock_init(&sem->spinlock);
	sem->count = count;
	return 0;
}

int
ZTsem_destroy(ZTsem_t *sem)
{
	ZilvioTHREAD_waitqueue_cleanup(&sem->waiting);
	spinlock_cleanup(&sem->spinlock);
	return 0;
}

int
ZTsem_post(ZTsem_t *sem)
{
	spinlock_lock(&sem->spinlock);
	sem->count++;
	if (sem->waiting != NULL) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wakeup_one(&sem->waiting);
		running_queue_size++;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&sem->spinlock);
		pthread_yield_np();
		return 0;
	}
	spinlock_unlock(&sem->spinlock);
	return 0;
}

int
ZTsem_wait(ZTsem_t *sem)
{
	spinlock_lock(&sem->spinlock);
/* Loop for spurious wakeups - though this should never happen */
	while (sem->count == 0) {
		spinlock_lock(&running_queue_spinlock);
		ZilvioTHREAD_wait(&current, &sem->waiting);
		running_queue_size--;
		spinlock_unlock(&running_queue_spinlock);
		spinlock_unlock(&sem->spinlock);
		pthread_yield_np();
		spinlock_lock(&sem->spinlock);
	}
	sem->count--;
	spinlock_unlock(&sem->spinlock);
	return 0;
}
