#include "ZilvioTHREADS.h"

int
ZTsem_init(ZTsem_t *sem, int pshared, unsigned int count)
{
	ZTpthread_cond_init(&sem->condition, NULL);
	ZTpthread_mutex_init(&sem->mutex, NULL);
	sem->count = count;
	return 0;
}

int
ZTsem_destroy(ZTsem_t *sem)
{
	ZTpthread_mutex_destroy(&sem->mutex);
	ZTpthread_cond_destroy(&sem->condition);
	return 0;
}

int
ZTsem_wait(ZTsem_t *sem)
{
	ZTpthread_mutex_lock(&sem->mutex);
	while (sem->count == 0) {
		ZTpthread_cond_wait(&sem->condition, &sem->mutex);
	}
	sem->count--;
	ZTpthread_mutex_unlock(&sem->mutex);
	return 0;
}

int
ZTsem_post(ZTsem_t *sem)
{
	ZTpthread_mutex_lock(&sem->mutex);
	if (sem->count++ == 0)
		ZTpthread_cond_signal(&sem->condition);
	ZTpthread_mutex_unlock(&sem->mutex);
	return 0;
}
