UNIT number;
{ written 21.6.95 Christian Schuld      }
{ Displays numbers in different formats }

INTERFACE

function Hex8(b:Byte):String;
function Hex16(w:Word):String;
function Hex32(d:LongInt):String;
function Hex(d:LongInt;b:Byte):String;

function Bin(d:LongInt;b:Byte):String;

IMPLEMENTATION

const digits:array[0..15] of Char=('0','1','2','3','4','5','6','7',
                                   '8','9','a','b','c','d','e','f');
      bins  :array[0..1] of Char=('0','1');

function Hex8(b:Byte):String;
begin
  Hex8:=digits[b shr 4]+digits[b and 15];
end;

function Hex16(w:Word):String;
begin
  Hex16:=Hex8(w shr 8)+Hex8(w and 255);
end;

function Hex32(d:LongInt):String;
begin
  Hex32:=Hex16(d shr 16)+Hex16(d and 65535);
end;

function Hex(d:LongInt;b:Byte):String;
var s:String;
begin
  s:='';
  while b>0 do
  begin
    s:=Hex8(d and 255)+s;
    d:=d shr 8;
    Dec(b);
  end;
  Hex:=s;
end;

function Bin(d:LongInt;b:Byte):String;
var s:String;
begin
  s:='';
  while b>0 do begin
    s:=bins[d and 1]+s;
    d:=d shr 1;
    Dec(b);
  end;
  bin:=s;
end;

begin
end.
