#pragma pagelength ( 60 )
#pragma pagewidth ( 132 )
#pragma optimize(5,SPEED)
#pragma code
#pragma objectextend
#include <reg51.h>
#include <equates.h>
#include <protype.h>
#include <decrypt.h>


extern unsigned char code ext_ee[];
unsigned char indata[0x20];
unsigned char outdata[0x08];

/* because we have these values in ROM, all special addresses have to */
/* be modified in ram */
unsigned char mod81, mod83, modaa, mod7e, modfe, mod08, modc0, modbf, modee, mode7;

unsigned char data guardtime;
bit convention = INVERSE;
unsigned char answer_40;

void main ()
{
unsigned char screen;
unsigned char counter;
unsigned char dummy;
unsigned char index;
unsigned char instruction_class;
unsigned char instruction_code;
bit instruction_code_valid;


char code version[] = {"SKY 09 - V1.05 - 15/08/95 - 16Mhz"};

guardtime = 1;


for (dummy=0 ; dummy < 0xff ; dummy++ )
{
  index +=1;
  index -=1;
}

while ( 1 )
{
reset = TRUE;
while ( !reset );
reset = TRUE;
while ( !reset );

/************************* over the air addressing **********************/

mod81 = ext_ee[0x81];   /* preload values */
mod83 = ext_ee[0x83];   /* preload values */
modaa = ext_ee[0xaa];   /* preload values */
mod7e = ext_ee[0x7e];   /* preload values 7.4.95 */	
modfe = ext_ee[0xfe];   /* preload values 7.4.95 */
mod08 = ext_ee[0x08];   /* preload values 17.5.95 */

/***********************************************************************/

answer_to_reset ( );	/* transmit answer_to_reset sequence */

do
    {
    while ( ! receive_iso_async ( & instruction_class ) );/* instruction_class */
    receive_iso_async ( & instruction_code );             /* instruction_code */
    receive_iso_async ( & dummy );                        /* P1 */
    receive_iso_async ( & dummy );                        /* P2 */
    receive_iso_async ( & counter );                      /* character_counter */
    if ( instruction_class == 0x53 )              
        {
        instruction_code_valid = 1;
	index = 0;
        switch ( instruction_code )
            {
            case 0x74 :
                        transmit_iso_async ( 0x74 );  /* acknowledge */
                        do
                            {
                            receive_iso_async ( & indata [ index++ ] );
                            }
                        while ( -- counter );
                        decode();
                        break;
            case 0x78 :
                        transmit_iso_async ( 0x78 );  /* acknowledge */
                        do
                            {
                            transmit_iso_async ( outdata [index++] );
                            }
                        while ( -- counter );
                        break;
            case 0x7a :                                
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        transmit_iso_async ( 0x80 );
			counter--;
			do
			{
			   transmit_iso_async ( 0x00 );
                        } while ( -- counter );
                        break;
            case 0x70 :
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        do
                            {
                            transmit_iso_async ( 0x00);
                            }
                        while ( -- counter );
                        break;
            case 0x7c :                                 
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        do
                            {
                            transmit_iso_async ( 0x00);
                            }
                        while ( -- counter );
                        break;
            case 0x7e :                                 
                        transmit_iso_async ( instruction_code );  /* acknowledge */
			transmit_iso_async ( answer_40 );
			counter--;
                        do
                            {
                            transmit_iso_async ( 0x00 );
                            }
                        while ( -- counter );
                        break;
            case 0x82 :                                 
                        transmit_iso_async ( instruction_code );  /* acknowledge */
			transmit_iso_async ( answer_40 );
			counter--;
                        do
                            {
                            transmit_iso_async ( 0x00 );
                            }
                        while ( -- counter );
                        break;
            case 0x76 :
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        do
                            {
                            receive_iso_async ( & dummy );
                            }
                        while ( -- counter );

                        break;

            case 0x80 :
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        receive_iso_async ( & dummy );
			answer_40 = 0;
			if ( dummy == 0x00 ) answer_40 = 1;
                        break;

	    case 0x72 :
                        transmit_iso_async ( instruction_code );  /* acknowledge */
                        do
                            {
                            receive_iso_async ( & dummy );
                            }
                        while ( -- counter );
                        break;

            default   :
                        instruction_code_valid = 0;
                        break;
            }
            if ( instruction_code_valid )
                {
                transmit_iso_async ( 0x90 );  /* SW1 */
                transmit_iso_async ( 0x00 );  /* SW2 */
                }
            else
                {
                transmit_iso_async ( 0x6d );  /* instruction_code not supported */
                transmit_iso_async ( 0x00 );  /* instruction_code not supported */
                }
        }
    else
        {
        transmit_iso_async ( 0x6e );          /* instruction_class is invalid */
        transmit_iso_async ( 0x00 );          /* instruction_class is invalid */
        }
    } while ( reset );

}/* while ( 1 ); */
}/* main */

void answer_to_reset ( )
{
unsigned char code answer_to_reset_sequence [ 0x10 ] = 
{0x3f,0xfa,0x11,0x25,0x05,0x00,0x01,0xb0,
 0x02,0x00,0x00,0x4d,0x59,0x00,0x81,0x80 };

unsigned char index;

for ( index = 0x00 ; index < 0x10 ; index ++ )
    {
    transmit_iso_async ( answer_to_reset_sequence [ index ] );
    }
}
