Walkthrough for WORLDS OF ULTIMA II: MARTIAN DREAMS

INTRODUCTION

MARTIAN DREAMS is the second game from Origin that does not take place in the
realm of Britannia, but takes you instead to an alternate reality through a
timegate created by the Orb of the Moons. Where the first game, SAVAGE EMPIRE,
transported you to the hidden valley of Eodon on Earth in what I assumed was
our own time period, MARTIAN DREAMS occurs on Mars in the year 1895. This must
take place in an alternate universe, or every single trace of the events must
have been obliterated and the dozen or so historical figures that participated
must have been sworn to silence. The story line has holes in it that you could
drive a truck through, the time paradox isn't sufficiently explained, but it
is a a lot of fun.

In your present day Earth, a strange woman arranges a meeting between your-
self and Dr. Johann Spector at your place. After giving you some mysterious
reading material, she disappears, leaving you and the redeemed villain from
SAVAGE EMPIRE to make the next move. There are two books, a note, and a
map, all written almost 100 years ago, as well as an old photograph. Both
books were written by Dr. Spector in 1895. The first tells how the adventure
began (will begin?) and contains brief biographies of each of the historical
figures in the game. The second book describes the premature firing of
Lowell's space cannon at the 1893 World's Fair which sent these people to
Mars, most of them unwillingly. It contains information about Mars, gathered
by the first expedition and relayed back to Nikolai Tesla on Earth with a set
of reflectors.

The note was written by Tesla himself, so he would believe your story when
you arrived to join the rescue mission. The map had directions that led you to
Tesla's laboratory, and using the Orb of the Moons as described in Spector's
book it seemed that you and he could travel back to the same spot in 1895. In
addition, you discovered definite proof that you must have participated -- an
old photograph of you and Dr. Spector standing with the members of the rescue
expedition.

This was a mystery, and combined with the woman's cryptic parting message
about saving both worlds, it was clear what you and Spector had to do. You
traveled to Tesla's lab, opened a timegate to 1895, and met the other rescu-
ers. Showing Tesla's note to him left him with no doubt that your story was
true, and you joined the party when they journeyed to Mars.

All this is covered in the lengthy opening sequence. Now, you must find a way
to return the 1893 expedition to Earth. This is not a simple task, for you
must help finish the space cannon being built on Mars, rescue several people
whose minds have been taken over by Martians, and get the entire planet
running again. This adventure is no doubt more complex than SAVAGE EMPIRE, and
you will need help from almost all of the characters in the game.

SURVIVAL ON MARS

As detailed in Spector's book, Mars in 1895 has extreme cold weather, a low
amount of oxygen in the air, and some very strange lifeforms. You will only be
able to travel at night until about 10 P.M. -- even if clothed very warmly --
before you start taking damage from the cold. When it gets close to that time,
you had better find a safe place to pitch your tent, and it is not a good idea
to eat any Martian berries before bedtime as the party will not be able to
rest until the effect wears off.

You can find a lot of equipment in your ship, although I was not able to find
enough clothing for Nellie Bly and that meant an early bedtime of about 7:00
until I found an arctic parka in Calamity Jane's trunk which I took. I played
the entire game the first time fighting only with sabers, machetes, and
occasionally an elephant gun. I didn't figure out how to open the nailed
crates until late in the game, and that's where the best equipment and weapons
were! Weapons safety is important. Never, ever give any gun set to shotgun to
a party member who you don't set to Command action: all the party will suffer
when he fires right through you to hit his target!

There are many places to find tools and weapons, so if you leave a shovel or
pliers somewhere, you can usually find another pair elsewhere, many times near
a location that it is to be used. Weapons range from simple knives, machetes,
and slings to pistols, rifles, and shotguns and a few ray guns which are load-
ed by U)sing radium chips. Armor is pretty simple: the tougher the clothing
the more protection from damage the character receives as well as extra warmth.

There seems to be no moral code on Mars, you can pick up anything you find.
For those steadfast Avatars, there is an exchange system that will allow you
to buy what you need fairly. Oxium, the chewable oxygen supplement is the main
currency, and things are priced very steeply. I wouldn't spend any oxium on
items until I got into the Motherlode or found another supply of geodes on one
of the northern plains, with the exception of perhaps buying Nellie warmer
clothes. The three berry types with special properties may be traded for
oxium, and there are a few good patches of berry bushes which can be har-
vested. After picking the area clean, just leave for awhile and return to
find them replenished.

Three types of Martian berries will give you mental powers for a limited
time. Purple berries give you telekinesis, the ability to U)se, G)et, and
M)ove objects from a distance. Green berries are able to let you T)alk to in-
animate objects, and if the object has any thoughts it will glow. There's only
two uses for them that I know of in the game, talking to the Hellas Dream
Machine and gaining mental power in the Argyre endgame. The brown berries pro-
vide spatial awareness, and when U)sed they will turn night into day whether
outside or in a cave, allowing you to see objects through some obstructions.
Blue berries will make you dizzy for awhile, but will cure radiation sickness
should you touch radium directly without tongs.

Unfortunately, due to the way the lifeforms reproduce, they reappear in the
same locations almost as quickly as the berries. I found the Creeping Cacti
to be probably the hardest opponents, due to their large numbers. It may take
you several tries to reach Cooter's place at the beginning of the game as a
large force of Cacti stand between you and Noctis Labyrinthus.

No one actually dies in battle, they "fall" instead. When you are overcome,
the entire party is found by Dr. Yellin and carried back to your landing sight
where Dr. Blood revives you. Fallen or injured party members can be treated on
the field by using the oxygen canisters Dr. Blood prepares, restoring them to
full health. Each canister weighs 15 pounds, so it may not be feasible to
carry more than one. Dr. Blood seems to be the only person that can render
medical treatment.

Experience accumulates quickly during the game, and when you pitch your tent
for any period the party members due a level increase get to increase one stat
by choosing between a Sword (strength), a Heart (dexterity), or a Book (in-
telligence). I saw no advantage to Intelligence, concentrate on the other two.
Before camping, always see who may be due a level increase, and decide then
what statistic to raise as you can't view their abilities when the question is
asked.

TIPS, TRICKS, AND SPECIAL LOCATIONS

Note: This section covers some tricks you can use during the game, as well as
locations of some places not covered in the walkthru. This also tells you the
location of the "ruby slippers," an extreme "spoiler" that will allow you to
see the endgame sequence early!

There is a good supply of oxium geodes located on the Acidalia Planitia at
about 38N, 58W. Most are located one level above you and you can only reach
them by U)sing a purple berry to gain telekinetic power. Another source of
geodes is found in the canyons that wind through the northern part of Syrtis
Major Planum at 30N, 54E. However, both these locations may have oxy-leechs in
the area. They won't take your geodes, but they will snatch loose oxium then
run away. It has also been said by other players that there is a way to buy
things from the traders without spending any oxium. If your Avatar puts at
least 500 blobs of oxium into a small pouch, they say that the traders won't
take any from you. I didn't test this idea, but it is mentioned here for those
who want to try it.

If an overwhelming force of hostile plantforms are nearby, the screen scroll
will slow down to a crawl. If you don't feel up to the fight, U)se the spy-
glass in their direction a few times and they'll vanish for a while. You'll
only be able to use this technique outdoors in the daytime, but it is useful
to escape the occasional large group of creeping cacti.

Devil pods, if you can find them, can be useful when confronted by a large
group of jumping beans, for example. If you D)rop one in the midst of the
pack, it splits open and the pod devil will attack anything around it. How-
ever, if it is still alive when the chosen enemy is gone it will turn on you.

There is a good patch of berry bushes located between Ascraeus Mons and
Xanthe Terra at approximately 12N, 70W. Another fair source is near the power
station at 13N, 26W. After you pick an area clean, just walk away from the
area for a while and it will be replenished when you return. Unfortunately,
the creatures that were there will also be regenerated.

Across the bridge at 4S, 121W and south to Aonia Terra you will find a "box
house" at about 29S, 106W. You should find some radium chips in a lead box 
here as well as a heat ray gun. Ray guns are powered by U)sing radium chips, 
giving them 30 charges, but they are used up very quickly if you set the gun 
to either shotgun or combination. Freeze ray guns can temporarily freeze 
attacking plants as well as humans, so be cautious when using them.

There is a small house near 69S, 135E that contains a heat ray gun. You will
also find another heat ray gun in Elysium, a freeze ray gun in Kaxishek's
polar laboratory, and another freeze ray gun when you finally get into Argyre.
Argyre also contains a bag with 15 chips of radium and large stores of ammuni-
tion for your firearms, but by the time you get inside there really isn't much 
fighting left to do.

 The ruby slippers are buried under a rock at 57S, 50E. If you put them on and
U)se them three times, you will be given the option to see the endgame graphic
sequence now and return to DOS. You will be able to restore the game from the
last point you saved it.

GETTING STARTED

 You can equip your beginning party pretty well from just the equipment in 
your ship, located at 26S, 146E. It's interesting to talk to your fellow 
passengers, but the important thing is to get the prybar from Dallas Garrett 
with the word NEED. Mention GEAR to him and he will suggest you get the sex-
tant in the back of the ship. Prybar in hand, enter the back of the ship and 
open all the crates, trunks, chests, and barrels. You should find a pistol, 
rifle, and a Belgian Combine in the northwest crate, and the crate next to it 
contains 100 pistol rounds, 40 shotgun shells and 100 rifle rounds. The 
Belgian Combine may be U)sed to set it to Rifle, Shotgun, or Combination, 
therefore it can use rifle bullets, shotgun shells or fire one of each per
round.

 NOTE: When you see a capitalized word in this walkthru, it usually refers
to a key word that will get more information from the person you're talking
to. These words appear in red letters if you have the help on.

 The carpet bag contains most of the tools you'll need to play the game, a 
pair of pliers, a pair of tongs, a wrench and a sledge hammer. The backpack 
comes with a lantern and 5 cans of oil, the all-important tent, and a tinder 
box.  There should also be several machetes, an axe and a saber as well as 
various items of clothing which you should try to distribute evenly among 
yourself, Spector and Nellie Bly. Initially, you may want to equip everyone 
with machetes and your Avatar with the saber, although I'm not certain which 
weapons are the best. If a character is equipped with two weapons he is given 
two attacks per round. In one crate you'll find the sextant and telescope, and 
several other containers contain ornamental items that I doubt have any use in 
the game. After raiding the hold, you might talk to Tesla and mention 
COORDINATES to find that the previous expedition landed at 28S, 153W.

 A note about coordinates and the game map - the latitude and longitude aren't
marked, but each line of latitude covers 10 degrees and each line of longitude
is equal to 20 degrees. The center of the map is at 180, 0 and runs almost
directly through the Amazonis Planitia. The longitude numbers from this spot
proceed from 180W to 0 as you head east, and from 180E to 0 as you head west,
wrapping around at the left and right edges of the map. The latitude progress-
es from 0 to 70 from the equator both north and south. The longitude seemed
confusing at first, I wish they would have centered the map on 0, 0.

 Attempt to U)se the prybar on the hatch, and Dr. Blood will stop you to ask
a question whose answer can be found in one of the two books that came with 
the game. This is the only copy-protection I found, and when you answer cor-
rectly Blood will allow you to continue. After opening the hatch, Blood will 
speak up again, warning you of the risk to your health and telling you about 
the oxygen canisters he'll begin preparing. Immediately, and whenever without 
oxium in your inventory, your strength and dexterity will drop by 4 points 
each while your intelligence will drop by 3. There are no great battles to 
fight if you journey almost directly east to the 1893 site, and there you'll 
recruit another party member who has a small amount of oxium.

1893 LANDING SITE

 Heading almost directly east from your ship and edging around the southern
edge of the forest, you'll soon reach the previous landing site at 28S, 153W.
You'll know when you're close when you spot the long east-west trench that the
space bullet left as it landed. In the crate just to the left of the hatch, 
you find 50 pistol rounds, and in the cockpit you'll find an elephant gun with 
50 shells. Inside the crate under a book you'll find a weed sprayer, which can
hold 30 charges of weed killer. The weed sprayer may be your best weapon
against the creeping cacti that you'll probably encounter as you head towards
Noctis Labyrinthus, and there is one can of weed killer (10 charges) in the
rear hold. The phlogonistite can't be removed - by you.

 Leftenant Dibbs is here, left by Percival Lowell to await a second expedi-
tion, namely you. He has much useful information about what happened since 
messages stopped being sent to Earth. Mention EXPLORATION and he tells you 
that when Mr. Carnegie ran out of iron ore to make steel for a space cannon, 
the expedition split up into four main groups to explore the planet. Three of 
the groups set up residence in the abandoned Martian cities that they named 
for nearby landmarks, while Calamity Jane and Buffalo Bill set up an OUTPOST 
at 12S, 129W and became TRADERS.

 Jack SEGAL settled in OLYMPUS, at 10N, 110W and soon his group took over the
CANNON construction site on Olympus Mons. He became very CAUTIOUS, barring the
settlement from all outsiders that might have been CONTAMINATED by the Dream
MACHINES. You'll hear a lot more about these as the game goes on, if you 
prompt Dibbs with DANGEROUS he'll reluctantly elaborate.

 Percival Lowell and his group found a working Dream Machine in ELYSIUM, near
Elysium Mons at 20N, 114E. He attempted to utilize the machine to communicate,
and now they are all MAD, believing themselves to be Martians. Shortly after,
someone smashed the communications REFLECTOR.

 Grigori RASPUTIN found ARGYRE on the Argyre Planitia at 30S, 107W and closed
off almost all communication with others. Little is known about his business,
and you won't get to meet him until near the end of the game.

 Lt. Dibbs will also tell you of the transport TUBES, of the four BRIDGES that
were extended over the empty canals, and of CRAZY MARCUS who escaped the Dream
Machine and moved to HELLAS at 27S, 77E. Marcus claims to know secrets about
the Dream Machines and to have been able to talk to inanimate objects.

 These give you an abundance of leads to follow up, but if you refer to Nellie
Bly's NOTEBOOK when you talk to her, you will be reminded that you need to 
find a reliable source of oxium. Ask Dibbs about OXIUM, and he'll tell you how
it is used, and of MCGEE who prospects for it. Dibbs joins your party, and you 
can divide the 20 oxium he carries amongst your group of four. He suggests you 
now should visit the TRADERS at their OUTPOST on Arsia Mons at 12S, 129W.

TRADERS, RESCUING COOTER

 After your conversation with Dibbs, you may have a better idea of what the 
game is all about. However, your first priority should be obtaining a large 
supply of oxium. You use 1 blob of the stuff each hour, and you only have 5 
apiece. From the 1893 landing site, head almost directly northeast to 12S, 
129W. There may be a couple of sextellegers to fight outside the outpost, I 
recommend the elephant gun to dispose of them.  

 In the outpost you'll meet Buffalo Bill and Calamity Jane. Bill sells TRAIL
goods such as tents, lanterns, and tinderboxes as well as AMMUNITION. Talk to
him about NOCTIS, and he'll tell you that a bridge across the canal is located
at 4S, 121W. Calamity Jane sells CLOTHING, and trades OXIUM for BERRIES. Ask
her about COOTER, who supplies their oxium, and she'll tell you that he hasn't
been around for quite a while. If you agree to help find him, Bill will give
you 30 more oxium and 3 purple berries when you mention OXY. He'll also give
you more information: The entrance to Noctis Labyrinthus is at 20S, 113W and
Cooter's cave is at 12S, 81W.

 There are a few items of good clothing in the trader's chests, I took the
arctic parka from Jane's stuff for Nellie to use. You can also find another 
can of weed killer, a pistol and more pistol rounds here.

 You can also find three substantial caches of oxium just outside the walls of
the trading outpost, buried in the chasm where you can't get them. However,
take the Martian shovel located right outside the door and U)se a purple 
berry. Now, you can U)se the shovel from a distance on the disturbed ground, 
then G)et the oxium you uncover. I found a total of 45 blobs, so it's worth 
the trouble.

 Leave the outpost and head almost directly northeast to the bridge at 4S,
121W. Cross the bridge and make a dash for 11S, 100W. This isn't the marked
entrance to Noctis that Bill told you about, but it is a straighter route to
Cooter's cave. If you're lucky, you'll avoid the group of Creeping Cacti that
will approach from the south. If not, you have a tough fight ahead, so save 
the game first. Equip your Avatar with the weed sprayer, and let the others
use the firearms.

 If you entered Noctis at 11S, 100W just go directly east to the cave 
entrance. If you entered at 20S, 113W where the marker flag is located, 
proceed east, turn north, then east again. Light a lantern by having a 
character ready it, then just U)se it. The oil is automatically loaded and the 
tinderbox is assumed to be used. Enter the cave at 12S, 81W and walk north 
until you see the plank on the other side of the chasm. U)se a purple berry, 
and you'll gain the power of telekinesis for a short period of time. You can 
U)se, G)et, or M)ove objects from a distance while the effect lasts. M)ove the 
plank to the south twice, and you can cross over into Cooter's cave. You'll 
find some more blobs of oxium and purple berries in here, and a small pouch 
containing more ammunition, but the big loot is to the north. The two notes 
you find here, one written by Cooter and one by Rasputin, indicate that the 
old man met with foul play in Coprates Chasma when he refused to reveal the 
source of his oxium to Rasputin.

 You could go directly to where Cooter is and rescue him, but first you should
explore the tunnels to the north. There is another plank to be moved, if your
psychic power has worn off just pop another purple berry. The branch to the
west contains nothing but bushrats and rat poison, and I could find no way to
U)se the rat poison. You will encounter ammonoids in the tunnels to the east,
but you will find many oxium geodes. Geodes may be broken with a hammer to 
G)et the oxium inside, the amount of which is randomized before the geode is 
broken. Since this quantity can vary quite a bit, a good technique is to save 
the game before opening the geode and restoring if you don't find enough. In 
my game, the amounts varied from a low of 7 to a high of 91.

 Cooter has barricaded himself in a cave to the southeast of Coprates Chasma,
and you must kill the ammonoids there to get to him. From Cooter's cave, go
directly south all the way to the rock, and the marker flag is to the east at
17S, 79W. This large open area is home to Sand Trappers, and they can be tough
opponents. They may be avoided if you stick very close to the walls and work
your way around to the southeastern corner. Continue east, south, and east
again and you'll find the cave at 21S, 64W. Enter and kill the ammonoids be-
fore moving the crates. If an ammonoid attacks Cooter, he will not respond
when you try to T)alk to him.

 After rescuing him, he tells you about a REE-ward, the MAP which shows where
his oxium stashes are. It's located one step west of the flag you passed at
17S, 79W and a SHOVEL is located under the rock to the west of that. The map
shows 3 STASHES of oxium located at 14N, 41W - 10N, 39W - 4N, 27W and 
indicates the MOTHERLODE inside the power plant at 13N, 26W. Cooter tells you 
that the huge stash of oxium is behind a closed electrical DOOR but there is 
no POWER to open it and that EDISON at OLYMPUS might know how to get it going.

 Leave the prospector, and if you like you may go get the shovel and map. If
you have a shovel already, you may just want to go straight to the stashes and
get them. The second stash at 10N, 39W was already uncovered when I found it,
but the other two contain a fair amount of oxium. If you got a good quantity
of oxium in Cooter's cave, you may want to go straight to Olympus, as there's
nothing much you can do at the power plant until you are allowed into Olympus.

GETTING INTO OLYMPUS

 Retrace your steps out of Noctis Labyrinthus and go to the Olympus gate at
2N, 112W. Talk to Nathaniel Peters here, who is guarding the gate against 
anyone not KNOWN to the residents, due to the LOONIES from ELYSIUM. He wants 
PROOF of your integrity, and if Dibbs is with you he offers to vouch for you. 
But Dibbs is feared to be tainted also, so he doesn't qualify. When Nathaniel
say that you must get 3 signatures on a note, Dibbs suggests the EXPLORERS. 
This is fine with Nathaniel, and he tells you that they were last known to be 
around Syrtis Major at 10N, 71E. He hands you a note, and will not speak to 
you again except to check the note.

 Walk around Olympus to 12N, 111W and cross this bridge. It's a long trip to
Syrtis Major, and you are likely to encounter several sextellegers, as well as
a Giant Maw if you stray too far into open plains. The best route is probably
to follow the canal edge westward around to it's north tip at 52N, 163W then
follow the polar ice cap to the canal at 52N, 123E. Continue south-southwest
past Elysium at 31N, 87E. Alternatively, you can cross the bridges at 18N, 
111W and 25N, 121E but you may encounter more sextellegers. Continue southwest 
then west to 10N, 71E to the mine at Syrtis Major.

 Dr. David Yellin is outside here, unable to help his companions who have been
trapped in the MINE by a CAVE-in while they were SURVEYING for IRON ore. There
is an unassembled DRILL in the building to the west, but Yellin doesn't have
the right TOOL. When you mention TOOL, if one of the party members has a 
wrench they'll speak up. If you have a wrench, and you should have one from 
the carpet bag in your ship, you're set. The crate in the southwest corner of
the building contains the drill part, G)et it then D)rop it on the drill base.
Connect the two pieces by U)sing the wrench, then you can M)ove it north and 
south only to get it to the track. Walking behind it will push it in the right 
direction, go north into the mine, turn west then north again until you reach 
the rock pile. U)se the drill a few times and you'll clear a path through.

 Leave the drill here, you'll need it later. You've rescued Major Greg Duprey
and Richard Sherman, T)alk to each and say NOTE to get them to sign. Duprey
doesn't have a lot of information, but Sherman immediately joins the party and
can be asked about almost every location that they've marked with flags. He is
a good source of information, ask him about ARGYRE, for example, to see what
you'll be up against there. With the explorers rescued, leave the mine and ask
Yellin about NOTE to get the third signature.

 Return to Olympus and T)alk to Nathaniel, who now will open the gates. Once
inside, you will be able to talk to several important people, and now the
story starts to get moving. The most important, in his own mind, is the leader 
Jack Segal, who resides in the northwest corner of his settlement of "RIGHT"-
thinking humans. Segal tells you he "persuaded" MARCUS to leave for HELLAS
after he used one of the DANGEROUS DREAM machines HERE, then used his influ-
ence to have the other people destroy it. Other important clues you can gain 
from him by talking to him about LOWELL, RASPUTIN, TRIPPET, JEAN and LEGRANDE. 

 The next thing you need to do is get into the Hellas dream machine, and this
first requires getting the electricity back on. The power plant is located in
the building where Cooter found the "motherlode," and you must get it started
up as well as repairing the broadcast towers. After investigating the plant,
you will have to return to Olympus to have a part repaired by Trippet.

POWERING UP THE PLANET

 The Martian power plant is located underground, and the entrance is in the
building at 13N, 26W. The complex has a few rooms with objects you can't use,
panels you can't understand how to use, and scrolls that explain how the 
system works as well as a history of the Martian industrial revolution. One 
room that is powered by electricity contains Cooter's "motherlode," oxium
geodes and bins of oxium that will provide you with all you need once you get 
the door open.

 Two mechanical men, Coker and Stoker, run the power plant. Talking to Coker
is not very productive, all you learn is that he brings the COAL from the wall
to the conveyor BELT. Stoker, at the other end of the belt, takes the coal and
feeds the FURNACE, which supplies POWER to the planet through the broadcast
TOWERS. He mentions that the cables above are fragile, and any sudden change
(like starting up the generator) could damage them. The furnace may be started
temporarily by hand-feeding it some coal in case of a shutdown, but to keep it
going requires a steady supply of coal from the Coker-Stoker team. Mention 
BELT to Stoker and he will tell you that this key link between the two robots 
is broken, and Dibbs will say that Trippet in Olympus could fix it.

 Take the broken belt, which weighs only five pounds and return to Olympus.
Talk to the would-be canal barge Captain Trippet and say BELT. He should fix
it, and you can then U)se it at the same spot you found it. Now, you should
find a Martian wheelbarrow in one of the rooms which you can push next to one
of the piles of coal lying around the furnaces. U)se a shovel to put the coal
into the wheelbarrow, push it next to the furnace then U)se the shovel to put
the coal into the furnace. The belt should begin to move, so clear the path
for Stoker, who's going to head straight for the furnace with a huge chunk of
coal. After a short graphic interlude, the power plant is again alive!

 Unfortunately, as Stoker mentioned, the electrical surge damaged the cables
that connect the broadcast towers outside the station. Inside the now active
power door is a 10 lb. spool of cable which you should now take. You need a
pair of rubber gloves, which Spector should have if you haven't discarded 
them. If you don't have these, I believe there was a pair in Calamity Jane's 
trunk at the outpost. You will take a lot of damage from the vents that are 
now spewing steam if you try to return the way you came, but there is a route 
back through the mines. You can enter the next room and take all the oxium 
geodes now if you want, and you may also U)se the oxium bins as much as you 
like, getting 20 blobs of oxium each time. This is the motherlode that Cooter 
told you about!

 Enter the tunnels to the south of the oxium bin room, and the path through to
the outside is fairly simple. In general, first go east, south and west, then
continue south and west to a four-way branch. Turning south, you should reach
a lighted passage where you'll fight some bushrats. At the end of this passage
is another power door leading to a room under the central set of broadcast
towers. In case you don't have one, there is a pair of pliers lying here. The
scroll explains the repair procedure, and if you have the cable, gloves, and
pliers you're ready to go. Go up the stairs to the surface and give the stuff
to your Avatar as all your other party members will decline the job - try to
get Nellie Bly to do it for a laugh. Now, ready the gloves, U)se the pliers on
the cable TO the tower. After another graphic sequence, the power should now
be spreading all over the planet, activating the transport tubes, bridges and
doors that will give you access to all sorts of new areas.

THE SECRET OF THE DREAM MACHINE

 If you just got the power back on and are at the broadcast towers at 4N, 15W
you can return to Olympus by following the canal to the bridge at 12N, 111W.
You should now investigate the only dream machine in the western half of 
Hellas at 23S, 62E which can now be reached as the bridges are operational. Go 
to the transport tubes just south from Olympus at 1N, 109W and enter the 
southwestern one, which will take you in a flash to the eastern part of Hellas 
at 34S, 72E. Before going to see the machine, find Marcus who may be found in 
the greenhouse at 23S, 75E.

 MAD Marcus was thrown out of OLYMPUS by Segal when he used a DREAM machine.
He tells you that LOWELL and the others at Elysium weren't crazy, but that the
MARTIANS POSSESSed their bodies when they used the machines. When you use a
dream machine, you enter a dream WORLD shaped partly by your own IMAGINATION.
Marcus believes that when the Martians began to die out, they escaped into 
this dream world, and while SOME were happy to wait for rescue from outside or 
to live forever inside, many others chose to inhabit the bodies of the humans 
who used the machines. The humans were TRAPPED in nightmares of their own, and
Marcus believes they can be RESCUED if there were a working machine. He also
says he discovered something IMPORTANT... you can leave the dream world by
T)alking to yourself to wake up.

 Marcus reveals that there is another dream machine on the ISLAND across the
canal that divides HELLAS, but that it seems to be broken. He thinks you can
FIX it, and furthermore states that the machine can tell you how to do it if
you talk to it! He claims that the BERRIES in the GARDEN to the east give one
the power of psychometry, the ability to talk to certain OBJECTS. The garden
is filled with JUMPING beans, and Marcus can no longer fight to get in. These
are green berries, and if you already have a supply you won't have to venture
into the garden at 26S, 83E.

 Use the lever to extend the bridge at 30S, 68E then enter the building with
the two fountains in front. U)se a green berry, and T)alk to the Dream
Machine. This "conversation" is more a series of feelings, you feel what the 
machine does. Thus, the "dialogue" is rather limited, it feels BLOCKED. It is 
DEAD, missing a large glowing ROCK known as radium. This is all the informa-
tion you will get for now, time to return to Olympus.

OLYMPUS MONS

 Back in Olympus, there are a few people that can give you information to help
you get the Hellas dream machine running again. You will have to go into the
mines of Olympus Mons to get some radium and attempt a rescue, and get Edison
to rewire a control panel from the underground access tunnel.

 Madame Curie is in a building just inside the front gates. Ask her about her
RESEARCH and REACTIVE ROCK. She will tell you that she believes the Martians
used small pieces of this for their machines and mechanical men while larger
pieces may have been used in larger devices, perhaps like the machine Segal
destroyed. The pieces she found in the MINES seem to attract terrible WORMS,
and the rock makes them GROW. She suggests a relationship between the size of
the radium deposits and the size of the worms nearby. Spector mentions to you
that unless you PROTECT yourself, exposure to radium may be fatal. When you
ask Madame Curie about this, she is rather puzzled (some have said that she 
died prematurely from her experiments with radioactive elements, not knowing 
the harmful effects), but she offers you the use of the tongs and lead box in 
her lab. If you don't have a pair, be sure to take these, and certainly take 
the lead box.

 The Olympus dream machine, ordered destroyed by Segal, is being reluctantly
guarded by Legrande Antoine Couillard while his BROTHER was sent to look for
iron ore in the MINES. Everyone is AFRAID to look for him because of the 
worms, but if you HELP find JEAN, Legrande will let you inside to look at the 
DREAM machine despite Segal's orders. Agree to help him, shaking his HAND, and 
you will discover he is a mason. Not a terribly important fact, but interest-
ing.

 Thomas Edison was very interested in the DREAM machine, but he had little
chance to STUDY it before Segal had it destroyed. However, he did get to see
the CONTROL panel, and believes that he could rewire almost any similar one
to function in a dream machine. He mentions that he saw one in the underground
access tunnel between Olympus and Olympus Mons, if you brought it to him he
could do the job.

 Enter the access tunnel at 12N, 117W and follow it to where it ends at 12N,
125W, picking up the panel along the way. Head around the mountain to the mine
entrance at 3N, 137W. Hearst has a shop near the tunnel exit, selling weapons
and Martian artifacts. You'll need to make a deal with him later, but right 
now you shouldn't need anything he's selling. There are going to be some 
pretty tough fights with worms in the mines, make sure everyone is rested up 
first.

 Inside the mine, go directly north all the way then turn west. You may fight
some oxy-leeches here, all I can advise you to do is to have your Avatar give
all his oxium to another party member then battle these critters in solo mode.
If the whole party gets into the fight you risk losing a lot of oxium. Go all
the way west, the tunnel that branches northeast has ammonoids and cave worms
but not much else. Follow the tunnel southwest, then go south as far as you 
can and turn east. When you start hearing "Body Critical!" messages, you're
getting close. Fight past the rock worms, and when you get close enough to 
Jean he will automatically talk to you, giving you his Masonic symbol as he 
expires. Here you should also find some blocks of radium, ready the tongs then 
G)et a block. Immediately M)ove it into the lead box, or you will be poisoned
by radiation. If you feel like fighting, you can get some radium chips to 
power any ray guns you find. I found two heat ray guns in here, one was in a 
tunnel past some rock worms and bushrats. The other was buried under the 
rubble you pass as you took the tunnel north, which can be cleared with a 
drill that you find off in the tunnel to the east.

 Leave the mine, and rest up outside. Chances are that one or more characters
have a level raise coming after fighting all those worms. Carnegie could have
been found if you took the tunnel to the west, but you'll be returning to talk
to him later anyway. Climb up to the top of Olympus Mons using the slopes at
14N, 153W - 14N, 149W - 10N, 147W. Fight the band of Proto-Martians here then
retrieve the camera at 9N, 145W. You will trade this to Hearst later after you
find someone to develop the plate. If you like, take a look at the barrel of
the space cannon near 9N, 138W before heading back down the mountain.

 Return to Olympus, find Edison and mention CONTROL. He'll rewire the panel in
your inventory to work on a dream machine. Now, talk to Legrande and break the
bad news to him about JEAN. After he takes the Masonic Symbol from you, allow
him a moment of mourning then talk to him again about his agreement to let you
see the DREAM machine. He unlocks the door, and there is the Martian device,
smashed beyond repair. However, there is one piece still functional here that
the Hellas machine lacks, G)et the headgear.

 With the rewired control panel, a block of radium and the headset in hand, 
you can now repair the Hellas dream machine. You will learn of the ruthless 
Martian villain who doomed his race to extinction, forcing the remaining 
Martians to flee into the dream machines. You will meet the benevolent 
Martians of Hellas, and rescue four of the nine humans who are trapped in 
endless nightmares while the Elysium Martians took over their bodies in order 
to live again.

HELLAS DREAM MACHINE

 Take the transport tubes to Hellas and cross the bridge at 30S, 68E and go to
the building that houses the dream machine at 23S, 62E. If you "talked" to the
machine earlier, you know the first thing it needs is the glowing ROCK. U)se
the block of radium on the power unit. If you now U)se a green berry to talk
to the machine again, you will find it still "feels" BLOCKED, it is still
UNDIRECTED and lacking a CONNECTION. D)rop the rewired panel on the cabinet 
and U)se the wrench to fasten it. Then U)se the headgear on the machine itself
and the machine is ready for a test run by your brave Avatar!

 Move your Avatar into the seat, then have another character (I used Spector)
go into solo mode and U)se the control panel. You fade into the strange world
of Martian Dreams, where you find five symbolic obelisks in the Hall of 
Dreams. Four contain dream worlds that hold the minds of H.G. Wells, George 
Washington Carver, Louis Comfort Tiffany and Vladimir Ilyich Lenin. The fifth 
holds the dream city of Hellas, inhabited by the Martians that lived there.

 The mind of Lenin is trapped in the obelisk marked with a hammer and sickle
in the southwest part of this hall. Walk to the front of the marker and enter
his nightmare. Wind your way through his "village," a mixture of people some
of whom seem to be living in comfort while others suffer in poverty. Lenin's
task is to evenly distribute the wealth of the village among the 25 people, a
noble idea but impossible in the real world even under socialism.

 Gather the rubles and you will also find an azurite stone. There are two
problems here: you will not have an amount of cash that can be divided by 25,
and you certainly can't divide the stone. Do your best, comrade, I found 253
rubles and so I dropped 10 each into 25 piles. This left me with 3 rubles and
the gem. Speak to Lenin again and tell him no, that you did not divide the
wealth evenly. Mention STONE, and he will ask you if you found the gem. Answer
yes, of course, and he will explain how he plans to dispose of the stone in an
equitable manner. It didn't sound kosher to me, but give it to him anyway. You
still have some extra rubles, so talk to him again and say no again. Mention
EXTRA, and he will tell you to divide the bulk evenly then tell him you have
divided it all fairly, even though you haven't. Fear not, for Lenin has the
answer to your dilemma. It still seems fishy, but give him the extra rubles 
and his nightmare is over. You awake in the company of your friends, although 
not really feeling that you've done the right thing somehow.

 Have Spector U)se the panel again, and reenter the dream world. Lenin waits
where his obelisk once stood, as will all the people you free until you free
these four as well as four more who are trapped in the Elysium dream machine. 
This time, go to the obelisk marked with a lamp in the southeast corner, this
is Tiffany's prison. It begins very strangely, your "mother" is attacking you!
You can't strike your mother, and if you stand there and take the punishment
you will eventually "die" and awaken! The solution is to run, run right off 
the edge of the cliff into an endless fall. Speed things up by pressing the 
"down" arrow, just before you impale yourself on a set of spikes you will be
transported to a relatively normal living room!

 U)se the book on the table and you'll read an interesting do-it-yourself
tutorial on bullfighting. Strange, there's no bull here, right? Get the red
throw rug lying here, but don't ready it yet! Walk along the path, and the
ground begins to shake. You soon reach Tiffany's shop, and his worst fear is
realized as there is a rampaging bull breaking up all his fine glassware and
china. Waste no time, head for the north wall and throw the switch that opens
the door. Now ready the throw rug, and wait until the bull notices. Lead him
through the door, drop your "cape" on the platform and slip past him through
the door. Tiffany thanks you, his nightmare is over, and you awake again.

 Your third rescue involves not so much a green thumb as it does strategy and
luck. I had to try this one a couple times to succeed, if you fail just T)alk
to yourself to awaken and try again. Approach the obelisk marked with a 
Martian pod in the northwest corner, this is where Carver resides. You must
make your way through a path strewn with Martian lifeforms, and slowly walk 
through a forest of wandering trees. If you can't get through here, pass turns 
until the trees move then try again. Further along the path is another such 
forest, patience is the key here. You reach an open area where the botanist
Carver needs your help to grow a Martian from seed to mature pod. Normally 
this isn't a problem, but cave worms are on the way. He gives you a bucket of 
water, 4 wormsbane seeds and a Martian ritual pod knife.

 Not much I can tell you here, start by U)sing the water on the pod plant that
Carter left behind. Pass a few turns, and you should see several cave worms
approaching. Plant a wormsbane seed or two in their path, and U)se the water
on them two times to produce a flower. This will repel the worms, but must be
watered again when the flower disappears. Attack the worms with your hands if
they get too close, you should be able to hold them off until the pod matures. 
If they get past you and get to the plant you've failed, T)alk to yourself and
try again. Once the pod is ripe, U)se the knife on it to cut it open. Carver
pops out, and thanks you for letting him experience the full Martian life
cycle. He tells you he will wait in the Hall of Dreams until EVERYONE is free.
He names the four humans in the Hellas dream machine as well as four others
trapped in Elysium. When you finish the conversation, you awake.

 Make sure you have your full hitpoints for the last rescue, it is the only 
one here that will involve real combat. H.G. Wells is trapped in the north-
eastern obelisk that is marked with footprints. You must negotiate a strange
maze filled with some mundane objects, some useful items and a lot of 
dreamstuff. If you have talked to Marcus in Hellas, you know that dreamstuff 
can be used to create things that you imagine. You won't have any control over 
the dreamstuff in the game, but you will be able to get the items you need by 
trial and error. At the end of the maze, Wells is surrounded by invisible 
Proto-Martians that you must find and kill to end the nightmare.

 The first patch of dreamstuff you find in the maze yields a weed sprayer, 
G)et it and follow the path until "You feel dizzy...." Your sense of direction 
has been altered by 180 degrees, east becomes west, northeast becomes south-
west, and so on. Knowing this, maneuver yourself to the purple berries and 
G)et them. This will allow you to G)et items and patches of dreamstuff that 
are out of your reach, and a couple of these are very good for fighting the 
Proto-Martians at the end of the maze. U)se a berry and G)et the knife or U)se 
the dreamstuff next to the knife which should yield a hatchet. Walk back to 
the east and you should see a bottle of green paint, G)et it. Fight the
Janitor and creepers, readying both the hatchet and knife will allow you two 
attacks per round.

 Just to the south of the janitor your directions will change again, this time
by 90 degrees. Northwest becomes northeast, north becomes east, east becomes
south, and so on. There is some more dreamstuff around here, most of it makes
some pretty useless stuff, but there is a group of four which will get you a
revolver and some pistol rounds. Continue along the maze towards the southwest
until your directions change once again, altered by 90 degrees the other way.
Northeast becomes northwest, north becomes west, etc. A little further along
you hit another change, 180 degrees this time just like the first time. The
platform off to the northwest contains some really useful stuff. U)se the
barrel to get 16 elephant gun rounds, and inside the carpet bag you should 
find an elephant gun.

 Finally, as you approach the marker flags, your sense of direction will re-
turn to normal. U)se the bottle of paint on the weed sprayer, ready it then 
approach H.G. Wells. When you T)alk to him, he'll tell you to get rid of THEM, 
INVISIBLE monsters that attack when you MOVE, and that he's not going anywhere 
until you get rid of them. When you end the conversation, they attack. The
best strategy to defeat them may be to first attack them with the sprayer, 
causing them to become visible then shoot them with the elephant gun. In 
addition, you may want to quickly move away to put some distance between you 
and them, although they will still throw rocks at you. This fight will drain
hitpoints from you in the "real" world, and it might take you a couple tries 
to defeat them, save before beginning the fight.

 After this battle, Wells is rescued and you awaken. All four humans will 
still have to wait in the Hall of Dreams until you free the other four trapped 
in the Elysium dream machine. Now enter the dream world once more and approach 
the one obelisk that remains, marked with a Martian. This is the dream version 
of the city of Hellas, and the layout is exactly like western Hellas where you 
are now. Five Martians "live" here, Prektesh the Agrarian, Xaktsesh the 
Arborist, Plashef the Cultivator, Pukchep the Gatherer and Chsheket the Am-
bassador. You will also find several scrolls in these buildings that contain 
some interesting myths about Mars, the moon Phobos, Earth and the asteroid 
belt.

 You find yourself inside the Hellas dream machine, exit the building and find
Prektesh in the building to the southwest. He is the Agrarian of HELLAS, the
finest grove on Mars. The DREAM-world became their REFUGE from the PLAGUE that
RAXACHK, Agrarian of ARGYRE unleashed in an attempt to rule the planet. The
BACTERIA doomed all the Martians as well as their OFFSPRING, forcing them to
flee into the dream world to wait FOREVER for someone to RESCUE them. He asks
for your AID to find them new BODIES. The ELYSIUM Martians took over the 
bodies of the humans that used their dream machine to attempt to grow new 
Martians from SEEDS, and Prektesh asks you to FORGIVE them for their CRIMES. 
He tells you that PLASHEF knows where the Hellas seeds may be found, and adds 
that their ARBORIST Xaktsesh was working on an alternative plan for new 
bodies.

 Plashef the CULTIVATOR is just to the northwest of Prektesh's home, and he 
has much information that you will need to grow a Martian. XAKTSESH warned him 
of the PLAGUE in time for him to put some SEEDLINGS in a SECURE place. Next to 
the Hellas greenhouse is a PRESERVATION unit that Plashef used to save some 
seeds from the SCHEMES of Raxachk. Plashef will tell you how the GROWTH of the 
seeds must proceed, you must plant the seed then water it. The proper FERTILI-
ZERS must be applied, a mixture of NITROGEN, PHOSPHATE and POTASSIUM, some 
samples of each are in his laboratory just outside the greenhouse. The seed 
takes nine days to produce a pod, during which you must look at it at least
three times, then the pod must be cut open.

 Xaktesh the ARBORIST "lives" in a small building southeast from Prektesh. She
does the needed HEALING in the Grove, although her skills are not needed in 
the DREAM-world. Her podmate KAXISHEK was RESEARCHING the creation of a diffe-
rent kind of body that would be unaffected by the PLAGUE. He based his LABORA-
TORY along the border of the northern icecap, in the belief the cold would 
slow the plague long enough for him to finish a PROTOTYPE. She HOPEs he was 
successful as he never followed her into the dream world.

 I met Pukchep the GATHERER wandering about, his duty is to help the KNOWLEDGE
of the dead Martians of his GROVE survive. He adds the REMAINS of the Martians
who die to the compost so that the life experience will pass on to new bodies
through the soil. Part of his job was also to trade CHEMICALS with Fazek from
Elysium, but he says you should ask Plashef for more information on that.

 Finally, Chsheket the AMBASSADOR of Hellas is usually found wandering just
south of her house which is located northwest from Prektesh. She doesn't have
much information to tell you other than the fact that ELYSIUM and ARGYRE seem
to have PLANS for producing bodies for transfer. She will be the one whom you
finally bring back into the real world, and she is to be a member of your 
party in the latter part of the game.

 T)alk to yourself to awaken, and polish off your green thumb. You have to 
grow a Martian and get one of the Hellas dream city citizens to transfer into 
it. It will be a tragic experiment, but necessary to prove your sincerity to 
the Elysium Agrarian Tekapesh, now inhabiting Percival Lowell's body.

GROWING A MARTIAN

 With your four human friends waiting in the Hall of Dreams, you now must gain
access to the Elysium dream machine to free the others. Tekapesh, the Agrarian
of Elysium, will not allow you to have their bodies back until you can prove
you are sincere in finding new bodies in which they can live. You have all the
information you need from the Hellas Cultivator to try and grow a Martian, and
almost everything you need is in Hellas.

 You will need to make a short trip to the northern icecap in order to get 
some ice, and this is a good opportunity to meet the "people" of Elysium. Pick 
up a bucket from either the Hellas greenhouse or one of the buildings in Olym-
pus as well as a pick, then take the northwest transport tube to the terminal 
at 30N, 112E. Inside Elysium are the eight humans whose bodies have been
possessed by Martians. If you've already been to the Hellas dream city, these 
people will not really be able to add to the information you have, but you 
might find it interesting anyway. The transfer to human bodies has left its 
signs, they are very unkempt and dirty, as they are trying to live as plants. 
While talking to them, you will notice they seem confused at times. You'll 
probably also notice that much of their human personality still comes through 
in the conversation, most noticeably in Lenin's case. 

 Bikchiz is the Elysium Ambassador who has taken the body of H.G. Wells. He is
also the HISTORIAN and will tell you about ARGYRE, RAXACHK, and of the disas-
ter that he brought upon the Martian race. Pashesh, the assistant to BIKCHIZ, 
took Lenin's form and will talk about any PLANTAL or Martian city. Xichack is 
a sort of naturalist, and is living in Wyatt Earp's body. He has EXPLORED most 
of the planet and knows about CREATURES such as the SUBTERRANEAN worms and he 
also will talk about WATER.

 Cheshef, also known as Carver, is the CULTIVATOR. He was only an assistant
when the plague struck down his predecessor, and doesn't know as much as he
did about the growth process. He tells you that the seed needs WATER and 
FERTILIZER and must be visited three times during the nine day cycle, but he
doesn't know much else. Fazek, the GATHERER, inhabits the body of Melies, and 
can tell you more about how the life experience is passed on through the soil 
through the COMPOST. He talks about TRADING with the Gatherer from Hellas for 
MATERIALS and CHEMICALS, and that there is a LABORATORY at 25S, 75E. Sisik, in 
the body of Mark Twain, is the ASSISTANT gatherer and can tell you more about 
how KNOWLEDGE is passed on through the SOIL to the DESCENDANTS.

 Chaktsaf, or Louis Tiffany, is the Elysium ARBORIST. The most important thing
he has to tell you is how the TRANSFERENCE will be done. As the soil is now
BARREN, the YOUNG Martian will not be born aware, but someone from the DREAM
world must transfer into the body by using the dream machines. Finally, the
Elysium AGRARIAN Tekapesh took Percival Lowell's body. He is the radical 
leader who will not relinquish the human forms until they succeed in growing 
BODIES for the TRANSFER. He will not allow you access to the DREAM machine 
here until you can show him some hope, or perhaps a better solution. He will 
talk about the PLAGUE and RAXACHK, the RESURRECTION of the true Martian FORM, 
and he will refer you to his fellow plantals when asked about other things 
like PODS and CULTIVATION. If you hadn't been to the Hellas dream city, all
this information would be more useful but less complete.

 Now that you've met the Elysium Martians, you should go all the way north to
the icecap and U)se the pick to chip off a chunk of ice. G)et it, then M)ove
it into your bucket before it melts. Kaxishek's lab is slightly west from here
but you won't be able to enter for awhile, now head back to Hellas to get a
seed from the building at 25S, 78E. Even though the power is on, this door is
rusted shut. There are plenty of places to find oil, if you haven't already
picked up some the easiest to find may be in Madame Curie's lab in Olympus.
U)se the oil on the door and you can now enter. There are four seeds here, you
only need one.

 Enter the greenhouse and U)se a shovel to dig a hole then D)rop the seed in.
U)se the shovel to move the dirt back in the hole and bury the seed. U)se the
water on the mound, then G)et the Nitrogen, Potassium, and Potash that you
should find around the greenhouse. If you have lost any of these, there should
be more in Elysium. U)se each chemical on the mound, and if you look at it you
should see a growing seed. If not, and you've messed up something, there are
three more seeds in Hellas as well as more chemicals in the other Martian
cities. However, it's pretty hard to get wrong, so now you just need to wait
nine days. You deserve a break anyway, so go outside the city and pitch your
tent repeatedly, checking your baby every three days. It should change into
three different forms, finally sprouting a pod. U)se any blade to cut the pod
open, and you should find an unconscious Martian!

Note: Just to be difficult, I decided not to look at the plant for several 
days to see what would happen. It didn't die, but it didn't advance to the 
next stage of growth. I waited a total of over 12 days, but it didn't grow 
every three days unless I actually L)ooked at it.

 You'll probably need to shuffle someone's inventory, as the Martian weighs 25
pounds. Get the Martian, which has no consciousness at all because the soil 
was barren, and carry it to the Hellas dream machine. You must visit the dream 
city of Hellas once more to find a Martian willing to attempt the transfer. 
Chsheket is willing to go, but Prektesh decides he must take the risk. T)alk 
to yourself to awaken, D)rop the Martian in the seat of the dream machine and 
U)se the panel to activate the transfer.

 A short graphic interlude follows as Prektesh moves into his new form, then
you are T)alking with "him." His TASK is now to grow bodies for all the dream
world Martians to move into. When you try to end the conversation, suddenly 
the Agrarian begins DYING! After stating that the plague could no longer be in
the AIR, Prektesh frantically tries to determine why his body is affected 
while you are still healthy. As you watch helplessly, he comes to the conclu-
sion that the plague must now be in the SOIL. Realizing that any new plant-
based body that is grown will be contaminated, he says you must talk to 
Xaktesh in the dream city about ALTERNATE bodies. He mentions the laboratory 
in the northern polar icecap, and tells you that you must win the trust of 
Tekapesh to be able to get any further. Taking his dead body to the Elysium 
Agrarian him will convince him that his plan will not work, and he will allow 
you to attempt your own plan.

 End the conversation, and Prektesh expires. Pick up his body and return to
Elysium. First you had to tell Legrande in Olympus about his brother, now you
must again be the bearer of bad news to Tekapesh. The Martian body is taken
from you, and he agrees to cooperate with your "schemes." However, to gain
access to the dream machine here in order to rescue the other four humans you
will have to prompt him again. Ask him about REBUILDING, and he admits that
PODS are not the answer, but that he and his fellow Martians will keep these
forms until something BETTER is offered. Answer yes when he asks you if you
know of another solution besides plants or worms, and he will allow you to try
and free your companions from the dream world. When all eight are waiting in
the Hall of Dreams he and the other body-snatchers will leave the bodies and
allow the humans to return, but they will not wait forever in the dream world
for you to succeed.

ELYSIUM DREAM MACHINE

 After Tekapesh gives you access to the Elysium dream machine, you are now set
to rescue the four humans trapped inside. Percival Lowell, Georges Melies, 
Mark Twain, and Wyatt Earp are here, and you must solve their dilemmas to 
release them from their nightmares. The Elysium dream machine is fully func-
tioning and you can enter the Hall of Dreams without problem, where once again 
there are four obelisks which represent each of the individuals imprisoned 
within.

 Percival Lowell is in the southeast obelisk, marked with a man holding a
telescope. You enter a set of platforms, each of which represents a planet in
the solar system. You begin on Mercury, and it is hot here! You'll take damage
as long as you're on this planet, but there are a pair of winged shoes lying
on the next platform. You start this dream with telekinetic power, so G)et the 
footgear of the mythical messenger and put them on. Walk across space to the
representation of Venus, where you find Cupid's bow and arrows, as well as a
mirror. G)et them both, ready the bow and arrows then continue on to Earth.
Here you find a note and a map left by Lowell, indicating that he went to the
planet Neptune to search for the ninth planet.

 On Mars you can T)alk to the metal woman who is the only HOPE for her race,
and her EXISTENCE depends on you. She indicates that the DESPAIR caused by the
plague is known and in the past, while she represents the unknown future which
you are somehow responsible to create. Now you must cross the asteroid belt to
reach Jupiter, a simple maze that requires using the asteroids as stepping
stones. There is only one possible path, just go in any direction that you are
allowed, visiting each asteroid.

 Cross over to Jupiter, then to Saturn. Shoot the red spot of Jupiter to charm
it if it gets in your way. On Uranus you'll find Lowell, who was unable to get
to Neptune to STUDY the SOLAR SYSTEM and discover Pluto. He needs a HERO to
take his telescope to Neptune, defeat the monster, find Pluto and then send a
signal back. Of course you volunteer, and he gives you his telescope. You can
signal him with the mirror when you reach the ninth planet and a shot from the
magic bow will allow you to get by the monster, a Martian Canal worm. Shoot
the worm, walk over to Neptune and U)se the telescope to the southwest to get 
a look at your destination. Just work your way across space in that direction,
it isn't a difficult path. U)se the hand mirror when you reach Pluto to send
a message to Lowell, who now realizes he is on Mars and that this was a dream.
He returns to the Hall of Dreams, and you awaken.

 The southwest obelisk is where Georges Melies is imprisoned, and the obelisk
bears a marking which looks like someone using a camera. In a dramatic 
fashion, the moving PICTURE maker explains that if you MOVE and touch CERTAIN 
squares, the WALLS close in, spelling certain DOOM. The door is rusted shut, 
and you must reach the dreamstuff on the opposite wall to imagine some oil, 
returning to open the door. The darker blue tiles are safe to step on, but 
each time you step on a grayish one the room narrows by one tile.

 The route is very simple: West, northwest, northeast, north, north and then
northeast. G)et the dreamstuff and U)se it to get the oil. Return to the door
by going southwest, south, southeast then south twice. Melies steps aside and
you can U)se the oil on the rusty door. Melies returns to the Hall of Dreams,
and you are allowed a moment in the spotlight before you awaken.

 Samuel Clemens, also known as Mark Twain, is in the northeastern obelisk that
is marked by a riverboat. Entering his nightmare, you join him on a riverboat,
actually a Martian canal barge. T)alk to him and he hands you a pilot's cap,
explaining that you must help him collect the PAGES of his manuscript which
were blown away and scattered along the "Mississippi." You must get the pages
to the POST office box in TIME, or he'll be in trouble with his publisher. The
pages are lying on shoals all along the "river," and you must steer the barge
along to G)et them. You need to find only 25 of the pages, and I counted about
35 lying around so you should have no problem.

 The difficult part of this sequence is navigating the barge among the shoals,
which are invisible at first. To see the obstructions you must first find a
piece of dreamstuff, and U)se it to imagine some brown berries. You should get
four berries, enough to finish the trip, but if you run out there is at least
one other patch of dreamstuff further down the "river" that gives you some
more. U)sing a berry gives you increased "spatial awareness," allowing you to
see the shoals. U)se the barge controller in the direction you want to go then
pass turns to move.

 After you have collected 25 pages, T)alk to Mark Twain again and he will put
the pages in order, making a manuscript that is ready for you to mail. The 
mail box is at the end of the "river" to the southeast, on a white platform. 
U)se the manuscript here, and Clemens will be able to escape. You awaken, and 
now there is just one more rescue to complete.

 Wyatt Earp is inside the last obelisk in the northwestern corner, which bears
a symbol of a marshall's badge and a gun. When you approach this obelisk, you
are suddenly back in the dream machine, being attacked by four Proto-Martians!
You have a piece of dreamstuff in your inventory, U)se it to create a saber 
and then dispose of the monsters. After this battle, you pass out from fatigue 
and awaken to discover that you actually slaughtered your companions! L)ook at 
each body to search it, and you will find money on your dead friends. G)et all 
the cash, you should find about 60 dollars, then leave the building and follow 
the winding path to the north.

 You enter an open area where a horse auction is about to take place, and you
find the notorious Ike Clanton. He's here for the auction, and you must make
sure you can outbid him for one particular HORSE. There are three for sale, a
BROWN one, a BLACK one and a GRAY one. Ike tells you that the black one is the
best of the lot, and that the gray one is going to be trouble. You may T)alk
to each of the horses, and if you played ULTIMA V or VI, you will realize that
the brown horse is the talking horse Smith! He recognizes you from SOMEPLACE,
you're the AVATAR who he used to give HINTS to. He wants you to BUY him, and
tells you that IKE is going to bid on MARSHALL, the gray horse. You can also
ask him about PISTOL, the black horse, but Smith tries to discourage you from
bidding on anyone but him.

 As Smith tells you, the black horse doesn't have much of a personality and if
you T)alk to him he has nothing to say. The gray horse is terribly confused,
he doesn't want anyone to BUY him, especially IKE. He must be FREE to protect
his HERD, and says you'll buy him instead. Now, T)alk to the AUCTIONEER and 
BID on the GRAY horse. If you bid on the other horses first, you won't have 
enough to outbid Clanton and buy Marshall. You can keep raising your bid until 
you get Ike to give up or you can just go ahead and bid 50 dollars right away. 
After you buy Marshall, T)alk to him again and FREE him. You will wake up, and 
now all eight humans in Hellas and Elysium should be waiting in the Hall of 
Dreams to return to their own bodies again.

 T)alk to Tekapesh again and mention BETTER. He honors the agreement, and in
another graphic sequence he and his fellow Martians return to the dream world
and allow the humans to have their bodies back. He repeats his warning before
he departs, that you will not have unlimited time to find them new bodies. Now
you can talk to the newly restored humans, and they will be able to help you
repair the ice melting stations located along the northern icecap.


MELTING THE ICECAP

 With all eight humans returned to their bodies in Elysium, they are now able
to talk with you about their professions and other subjects. More importantly,
two of them can help you fix the ice melting stations to get the water flowing
into the canals again.

 Return to Olympus and Peary will now talk about the STRUCTURES he found along
the polar ICECAP that he believes were used to MELT ice as a source of water.
He will tell you the THREE towers are POSITIONED along the northern icecap at
55N, 125W - 59N, 23W - 55N, 100E and that the system seems to have BROKEN 
down. He thinks that with the help of Tiffany, Carter and Edison you should be
able to REPAIR it.

 From Olympus, travel across the northern bridge almost directly north to the
first tower at 55N, 125W and pick up the broken lens, which weighs about 12
pounds. Now you can follow the edge of the icecap west to 55N, 100E and take
the broken tracking motor in the building at 55N, 100E or travel to Elysium
using the transport tubes at Olympus then travel north. Once you get the 
motor, return to Elysium and talk to Louis Tiffany. He can FIX most things 
made of GLASS, mention the BROKEN LENS and he will repair it. While in 
Elysium, talk to Carver about how the WEEDS that are surrounding the third 
tower at 59N, 23W may be DESTROYED with POISON. You should have found a weed 
sprayer in a crate near the SHIP at 28S, 153W as well as some weed killer. 
However, there are a few spray guns in Elysium and you can either find some 
weed killer inside the crate under a lantern in Sarah Bernhardt's house in 
Olympus or buy it from Buffalo Bill at the trader's outpost. T)alk to Lowell 
before you leave about how the LENS must be FOCUSED.

 Take the transport tube back to Olympus then T)alk to Edison about the MOTOR
and he will fix it. Now, U)se the lens on the tower at 55N, 125W then U)se the
motor on the tower at 55N, 100E. Follow the icecap west to the third tower at
59N, 23W and U)se the weed sprayer on the vines that cover it. (Attacking the
vines with the sprayer doesn't work, for some logical reason). Finally, L)ook
at your watch and U)se the panel. The alignment coordinate is represented by 
the military time with no separating colon. If it is 8:13 A.M. enter 0813, 
7:26 P.M. is entered as 1926.

 The following graphic intermission describes your success at dawn, the sun
comes up and is focused through the lenses, melting the ice to fill the huge
cisterns. Sherman suggests that you now check out the pumping station at 18N,
167W to make sure things are working right. Indeed, the job isn't finished 
yet, the water hasn't begun flowing through the canals. To turn the water on 
you will need someone impervious to steam and strong enough to turn a large 
valve. You must find and activate the mechanical body from Kaxishek's polar 
lab, then transfer a Martian from Hellas into it.

CHSHEKET'S NEW BODY, TURNING THE WATER ON

 With the icecap melting, you can enter Kaxishek's laboratory where Xaktesh's
podmate from Hellas was working on a body for the Martians to transfer into
that would be immune to the plague. You won't be able to do anything there
until you obtain a "heartstone," a piece of azurite which you must get from
Hearst in his Olympus shop. Follow the underground access tunnel in Olympus at
12N, 117W to the exit at 12N, 125W then T)alk to the famous entrepreneur in 
the building whose entrance is at 9N, 127W. He and Nellie Bly will have a few 
cross words at the beginning of your conversation, then ask him about AZURITE. 
He'll only trade it if you do a great FAVOR, something that will help increase 
his newspaper's circulation. He sent a photographer to take a picture of the 
space cannon up on Olympus Mons, and though he's worried about the man, he is 
much more concerned with retrieving the camera. If you followed this walkthru 
you already found the camera at 9N, 145W after defeating a band of Proto-
Martians who surely killed the photographer. If you don't have it, go get it 
now.

 With the camera in hand, mention CAMERA to Hearst, who will take it from you
and give you the plate. He'll tell you that you must have Georges Melies in
Elysium develop it first, so go there and ask Melies to DEVELOP the PLATE from
the CAMERA to produce a PHOTO. Return to Hearst and say PHOTO, and although he
gripes a bit about the quality he honors the bargain and gives you the gem. 
You now can install it in the mechanical body that you will find in the 
laboratory.

 Travel almost directly north from Elysium and enter the lab at 54N, 112E. The
central room is directly north, and there are side rooms to the east and west.
The west room contains nothing of interest, but in the east room you'll meet
the mechanical man named CUTTER, appropriate for his job. He can FASHION a GEM
into a HEARTSTONE if he has a piece of AZURITE. The heartstone is used in the
MECHANICAL men to hold the SENTIENCE of a plantal inside, giving it "life." He
cannot cut the gem as he has no POWER, his ENERGY source has run out and he
needs a radium chip. If you don't have any chips with you, just L)ook at the
mangled robot lying near Cutter and you will find 3 chips. G)et a chip with 
the tongs, U)se it on Cutter then mention FASHION again. He will cut the gem 
for you and give you the heartstone which you can now U)se on the mechanical 
woman in the laboratory. G)et the metal woman, which weighs 25 pounds, and the 
freeze ray gun in the southeast crate if you want, then return to the trans-
port tubes to travel to Hellas.

 D)rop the mechanical woman on the dream machine and U)se the panel. Chsheket,
the Hellas ambassador, transfers into her new body and now Sherman will leave
the party in order to make room for your new member. He drops all of his items
and you can have Chsheket pick them up. She has 240 hit points and will heal
as you do when you rest, or she can be repaired by Dr. Blood and Tesla at your
ship. I'm not certain if she can be revived if she is killed, but I suspect
she can be rebuilt by Tesla.

 Her first concern upon awakening in her new METAL body is to find some way to
make her appearance more acceptable to the humans. Nellie suggests that Sarah
Bernhardt at Olympus may be able to help, as she is an actress familiar with
makeup and disguises. Chsheket agrees, and adds that you should also talk to
the leader of the Olympus settlement, although I could get nothing useful out
of Segal. Gather Sherman's equipment, take the transport tube back to Olympus
and T)alk to Bernhardt about a DISGUISE. Spector explains that you need to 
make the bodies look human and Sarah says that she can create a pigment using 
ROUGE berries from Argyre to provide color, but this won't work without some-
thing to cover Chsheket's metal skin that can hold the dye. Now the Martian 
tells you how the mechanical men who work around the cisterns were coated with 
a water repellent substance that resembles human skin, and Sarah agrees to 
create a dye that will blend with the rubber coating when you bring her the 
berries.  

 You can't get into Argyre yet, but you can now get the water flowing through
the canal's with Chsheket's help. Leave Olympus, cross the bridge at 4S, 111W
and enter the pumping station at 18N, 167W. You will find a large room to the
west which contains the cisterns which are now filled with water as well as 
the pumping machinery. There is a mechanical man here named DIVER who keeps 
the pipeworks functional in the master PUMPING station, which controls the 
flow of water MELTED from the icecaps into the CANALS. Diver can't get to the 
WHEEL beyond the STEAM leaks that controls the flow because he isn't allowed 
to move  that far. He adds that there is a machine that applies a COATING to 
mechanical men in a room to the southeast, which is just south from the 
entrance. It uses a SEALANT that GREEN coloring was added to in order to make 
the coating more lifelike (to Martians).

 If you ask Chsheket about the STEAM, she will assure you that it will not 
hurt her new body, so put her into solo mode and send her south, west, then 
north. She can walk right through the steam leaks to reach the valve to the 
west and U)se it to turn the water on. Another set of pictures depicts her 
opening the valve and the canals filling with water from the cisterns.

 With this operation complete, all the systems on Mars are again operational,
and now you can transport iron ore from the mine at Syrtis Major to Carnegie
at the space cannon construction site inside Olympus Mons. You will be able to
get into Argyre to get the rouge berries, but only after you can prove that
you absolutely need to in order to recover another valuable item.

ORE FOR THE SPACE CANNON

 With the canals now filled you can use the barges to move around the planet,
but the return of the water has brought back the huge canal worms. If you talk
to Trippet in Olympus about his JOB, he'll tell you that he was originally
hired to pilot the CANAL BARGES, and he tells you the locations of all of the
ones he found. The only one you're interested in right now is the really large
one docked in Hellas at 27S, 62E. It has cannons on it which can be U)sed to
help kill the canal worms, and a track that will allow you to move a railroad
cart onto it. Take the transport tube to Hellas and U)se the lever in the 
barge dock to retract the bridge.

 Board the barge and U)se the control to navigate to Syrtis Major, following
the canal north to 6S, 67E then east to 6S, 106E. Continue north to 6N, 106E
then west to 6N, 72E and align the track on the barge with the middle track on
shore. Leave the barge and enter the mine, pushing the rail cart ahead of you.
Be sure to "park" the vehicle by U)sing the controller and pressing the space
bar to center it. If you forget to do this, you will have to follow the canal
to track down the barge.

 Inside the mine, push the cart north to the turntable and U)se a wrench to 
tighten the switch. U)se the switch to rotate the track, push the cart north
and U)se the switch again. Push the cart to the junction where the track turns
north and leave it there, you can't push it north. Follow the track north past
the rubble you cleared with the drill to free Sherman and Duprey. Move north,
pushing the drill ahead of you, then all the way down the first tunnel to the
west. Here is a Martian wheelbarrow and shovel, as well as a good deposit of
iron ore in the tunnel wall.

 Carnegie needs one full cart of iron ore to finish the cannon, and it takes
seven full wheelbarrow loads to fill the cart. As you moved the drill north,
you passed a cart on the track, return there and push the cart north to where
the tunnel branches west. Now you must go all the way west to the end of the
tunnel and U)se the drill on the iron ore deposit to produce a pile. U)se the
shovel to move the ore into the wheelbarrow then push it east to the cart. 
U)se the shovel move the load of ore into the cart and push the wheelbarrow
all the way back. Repeat this sequence six more times and you will have a full 
cart, it will contain seven loads of ore and its appearance will change. By
the way, because your fellow party members tend to get in your way, this task 
is easier to accomplish in solo mode.

 Push the filled cart south until it is adjacent to the one at the junction,
and U)se the shovel to move all seven loads into the empty cart. Push it east
to the turntable, U)se the switch then push the cart all the way south out of
the mine and onto the barge. After all that manual labor, you now can navigate
the barge to the space cannon site at Olympus Mons. Follow the canal east to
6N, 106E then north to 14N, 106E. Continue east to 14N, 165E and then north to
21N, 165E and east to 21N, 164W. Here you need to make a decision: The north
route is quite a bit longer as you must go all the way around, but there is a
barge parked in the southern branch at 8N, 164W which you will have to move to
the north of this junction if you want to get past it. I chose the northern
route because it was less complicated, but there are lots of creeping cacti
waiting along the south shore. That route continues north to 31N, 162W then
east past an island of berry bushes and jumping beans to 31N, 128W. Continue
south to 19N, 128W and east to 19N, 120W. Finally, south to 0, 120W and then
west to line up with the tracks at 0, 137W.

 Park the barge here and push the cart north into the mine to another turn-
table and U)se the wrench to tighten the switch. U)se the switch, push the 
cart north and U)se the switch again. Carnegie is to be found either at the 
west end of the tracks or in the small room to the east of the space cannon. 
Most of what he has to say you already know, he needs fresh RESOURCES to 
finish the SPACE CANNON. He only needs one more cartload of iron ORE to make 
enough STEEL with the Martian smelting MACHINE they found. The mine here ran 
dry, so he sent the EXPLORERS to look elsewhere while JEAN searched deeper 
inside Olympus Mons. The explorers reported back that they had found ore at 
Syrtis Major but could find no way to TRANSPORT it here.

 Carnegie will only recognize the ORE you brought so far if it is a full cart
of seven loads, and if you have pushed it most of the way down the western
track. After you explain how you got it here, no small task, he tells you that
now you need to retrieve the phlogonistite from the ship at the 1893 landing
site while his men continue to mine the ore.

GETTING INTO ARGYRE, MAKEUP FOR CHSHEKET

 Sometime after you get the canals filled, the phlogonistite in the ship from
the first expedition will be stolen. If you mention PHLOGONISTITE to Carnegie,
he will assume you have been to the site and discovered the theft, whether you
have or not. He suggest that you might find a clue at the scene of the crime
that you or Mr. ROOSEVELT could use to deduce the identity of the thief.

 If you now go to Olympus and talk to Roosevelt, he'll say he has a good idea
that the Russian monk RASPUTIN was the one who SABOTAGED the 1893 EXPEDITION
and that he took FINGERPRINTS from the original CAPSULE. He also believes one
of Rasputin's followers destroyed Lowell's REFLECTOR but he doesn't have 
enough EVIDENCE yet to prove his theories. If you consent, he will record your 
PRINTS as he has almost everyone else's. He needs a CLUE, something that 
Rasputin or his men touched so he can compare the fingerprints on it with the 
ones he found near the capsule fuse.

 Return to the rear hold of the 1893 capsule at 28S, 150W and you only find
some broken straps where the phlogonistite once sat. This is the clue you 
need, you should be able to take one of them. Before you show the strap to 
the Mars police, you need to get the microscope from Plashef's Hellas lab at 
25S, 75E so Roosevelt can search for fingerprints. Now he can draw the conclu-
sion that Rasputin sabotaged the expedition and stole the phlogonistite, al-
though I don't think he had conclusive proof. With no prints from Rasputin
himself, and not having the prints of every other human on Mars, all he could 
really prove is that the person who discharged the space cannon was the same 
one who stole the propellant. However, this is enough for him, and more 
importantly it will be enough to convince Carnegie that you really must break 
into Argyre.

 If you talk to Peary in Olympus you learn that ARGYRE is fortified by thick
GATES and that the cannonballs fired from the barge cannons are too soft to
blow them open. You will be able to breach the eastern gate if you can 
convince Carnegie to make some steel BALLS to load a cannon with. After you 
supply him with the ore for the space cannon, he will make a set if you have 
proof that you really must get into Rasputin's stronghold. Once Roosevelt con-
cludes that Rasputin stole the phlogonistite, Carnegie will take time to make 
the item which can be U)sed on the barge cannon at 4S, 9W. Cross the north 
bridge from Olympus and follow the canal all the way around, then navigate the 
barge to the canal spur at 32S, 29W. U)se the cannonballs on the cannon then 
fire it at the gates a couple of times to make an entrance.

 Once inside Argyre, you can go directly to where Rasputin is at 31S, 38W. You
can talk to Emma Goldman, a truly independent woman who definitely believes in
SPEAKING her mind. On earth she was an ORATOR who encouraged ANARCHY as a 
means to overthrow the GOVERNMENT that was run by the rich people like 
CARNEGIE. Her SPEAKING makes her very POWERFUL, and she sides with RASPUTIN 
because he will create a paradise on Mars where all people will be FREE and 
all things will be FAIR. She admits to breaking the REFLECTORS so that she 
could end Carnegie's monopoly on trading, and she threatens to do worse things 
now that they are alone here on Mars. 

 There is a lot of ammunition and some good weapons in some of the buildings,
another ray gun and 25 radium chips as well. These aren't going to be of much
use to you now, the rest of the game doesn't have much combat. It does make 
you wonder if there was another way into Argyre earlier, however.

 Rasputin's thugs won't bother you, they believe his mental powers make him
invincible. Ask him his name, and Chsheket gasps in horror as he reveals that
he is RAXACHK in the body of Rasputin! You immediately learn that he has 
hidden the phlogonistite in the DREAM world and that if you REMOVE it, it will 
set off a CATACLYSM that will DESTROY MARS and the dream world as well.
Spector confirms that this is indeed possible, and Chsheket seconds his 
opinion as her people had experimented with material transfers in the past.
She tells you that you must FREE her people from the dream world before you 
attempt to retrieve the explosive, and that means creating acceptable bodies 
for them. Rasputin declares this a futile effort, that the people of Earth 
will never accept robotic Martians as equals, and even if you succeed in dis-
guising the bodies you'll not be able to leave Mars with the propellant. In 
the mad Martian's eyes, you face a dilemma that you can't solve, and the final 
victory will be his. However, you must continue to try, and that means first 
getting the rouge berries for Sarah Bernhardt to make the pigment. When you 
return here with the transformed Chsheket, the situation will be very 
different.

 Get a clump of rouge berries from one of the bushes around the city then exit
Argyre through the east gate, walking around to the transport tubes at 34S, 
64W and return to Olympus. Tell the actress you have the ROUGE berries and she 
will mix a jar of pigment for you. Then return to the pumping station at 18N, 
167W and enter the room in the southeast area of the cistern room. Open the 
crate, G)et the rubber then U)se it in the sprayer. U)se the pigment on the 
sprayer, put Chsheket into solo mode to put her inside the machine, then U)se
the panel. In another graphic sequence, the metal body of the Martian ambassa-
dor is coated with the synthetic skin, transforming "her" into a beautiful
facsimile of a human female. Spector immediately provides clothing from some-
where to cover the shapely form, a convention that Martians aren't acquainted 
with, and suggests that she speak with the women about when it should be 
removed... you realize this is the strange woman who you met (will meet?) 
almost 100 years later!

 Now, the rest of the dream world Martians must be provided with equally nice
bodies that the humans on Earth will accept. Chsheket suggests that you see 
the leader of the Olympus settlement and get him to organize the construction 
of the mechanical bodies as rapidly as possible so the Martians can escape the
Dream world before it is destroyed. This is probably the only thing Jack Segal
is good at, making others go to work. Return to Olympus and talk to him, his
condescending attitude towards the Martians seems to have vanished after see-
ing the fruits of your labor. He will get the body construction started while 
you retrieve the phlogonistite, and the two expeditions as well as the new 
Martians will await you at the space cannon. You must return to Argyre, con-
front your own nightmares and defeat Raxachk in the dream world in order to 
return the propellant to the real world.

ARGYRE DREAM MACHINE, ENDGAME

 The humans at Olympus, under Segal's direction, are busy manufacturing bodies
for the Martians in the dream world. The space cannon at Olympus Mons is being
completed with the iron ore you mined, and everyone is preparing for immediate
departure. You must return to Argyre and enter the dream machine, find Raxachk
and retrieve the phlogonistite fuel.

 A massacre seems to have occurred in the Martian city since you left, all the
humans have been killed except Rasputin and Emma Goldman. She tells you that
RAXACHK murdered everyone but her, then forced her to operate the DREAM 
machine and transfer him back into the dream world. Emma kept the machine 
operating so that you could follow him, but the game logic requires that you 
talk to the  confused monk Rasputin and ask him his NAME before the machine 
will work. He tells you that he was lured to Mars by VISIONS that RAXACHK sent 
him on Earth, convincing him that he could RULE the planet. Raxachk took 
Rasputin's body, and the monk became TRAPPED in a nightmare where his enemies 
tried to shoot, stab, drown and POISON him. Rasputin was freed when Raxachk 
went back into the DREAM WORLD for unknown reasons.

 You must now got to the dream machine in Argyre and seek the Evil Martian,
retrieve the phlogoniste and escape from this dream world with the fuel. Save
before you enter here... you can't wake yourself up from this nightmare until
Raxachk is defeated, for his powers are too strong here. Enter the machine and
you will live one of your worst nightmares, the ShadowLords from ULTIMA V are
alive and well! They want to corrupt you by putting you in situations where it 
seems that the Principles of Truth, Love and Courage cannot prevail.

 Faulinei, ShadowLord of FALSEHOOD, and his two SIBLINGS who you thought you
DESTROYED in Britannia now seek to REEDUCATE you in their VIRTUES. Your first
TEST is to determine which of two dream figures is really your companion, 
Johann Spector. Each looks alike and speaks the same, but one is really a 
Martian and is LYING. When you determine which is the real Spector, go to the 
fake and call "him" a LIAR. The one object that will do the job is the mirror, 
located near the "Spector" at the east end of the maze. Move it in front of 
him and observe the reflection. If it is human, call the other "Spector" a 
LIAR, if you see a Martian, accuse "him." The door at one end of the maze will 
open, pass through it to your next test.

 The ShadowLord of HATRED, Astaroth, is waiting to give you your next lesson.
In his TEST, your three FRIENDS are being held by a wounded Martian who claims
VENGEANCE upon them for attacking "him." There are several patches of 
dreamstuff in this maze, some of which can be U)sed to imagine a freeze ray 
gun, a pistol and some pistol rounds. You might attack the Martian, but each 
time you do he will kill one of your friends. The solution can be found in one 
of the pieces of dreamstuff which will yield a healing potion. Just U)se the 
magic potion on your enemy to heal him. He will realize his error in acting 
out of anger and vengeance, he thanks you and then you are transported to your 
third "teacher."

 Nosfentor is the ShadowLord of COWARDICE, and her test involves merely show-
ing the COURAGE to save your friends Yellin and Duprey. At the patch of desert 
far to the north is a sand leviathan, the worst monster on Mars. As you run 
north along the path to save join them, various traps will chop your hit 
points down. If you choose to T)alk to the Martians on the east platforms they 
will ADVISE you of the TRAPS ahead and PLEAD with you not to go on. They tell 
you that a safe exit lies through the exit to the west, and that you should 
take the easy way out as your friends are doomed anyhow. If you U)se the 
dreamstuff that lies just before the monster you'll get a saber, but all you
really have to do is show your courage and step onto the desert in order to 
escape.

 With the three ShadowLords defeated and your virtue intact, you are suddenly
transported to a platform where Raxachk himself has barricaded himself behind
a crystal wall with the canisters of phlogonistite. The mighty Avatar does 
not frighten him, but he is bored waiting here to depart for Earth while his 
PLANS develop. If you ENTERTAIN him by winning three combats, he might GIVE 
you the PHLOGONISTITE. Agree, and you are transported to a small room where 
jumping beans attack. The dreamstuff here can be shaped into several items, 
but the only one that will help you right now is the machete. Arm yourself 
with it to defeat the jumping beans, getting as much of the dreamstuff as you 
can. If you kill all the critters, you'll be asked if you're ready for the 
next challenge. If you haven't gotten all the dreamstuff, especially the 
elephant gun rounds and the green berries, you may want to decline. The bridge 
to the first scene will still be there, you can return and get the rest of the 
dreamstuff.

 The second combat takes place in a cave, you must defeat the ammonoids here.
You really need to get one particular piece of dreamstuff here which will turn
into purple berries, before you kill all the creatures and are transported to
the third combat. Otherwise, there isn't much of interest here. When you have
finished off the ammonoids, you are transported to the third scene, a seeming-
ly empty desert. A sand leviathan lurks here, along with some more dreamstuff. 
It is easy to defeat this menace if you picked up the purple berries from the 
cave and the elephant gun rounds from the first scene. Stay on the white edge 
that goes around the desert, if you wander onto the sand the leviathan will 
attack. U)se a purple berry to get the dreamstuff lying on the sand, you 
should be able to find an elephant gun and some brown berries. U)se one of 
these berries, and the monster's maw becomes a visible target for your 
elephant gun.

 Defeat this monster and you are returned to the center platform where Raxachk
seems to have forgotten all about the game and the phlogonistite. He says that
there is nothing you can DO to HARM him, that you neither have access to any
more DREAMSTUFF nor the mental power to draw any from the void. Even if you 
had some, he says, your race wouldn't be able to imagine a weapon powerful 
enough to breach the walls of his CITADEL for a hundred years. Obviously, he 
doesn't realize where you really came from! U)se a brown berry to allow you to 
see the interior of the entrance room of his stronghold and you will see a
switch that will open the door as well as the dreamstuff hoard. U)se a purple 
berry to give you the ability to U)se the switch, then enter the room and
attempt to U)se the dreamstuff hoard. Your mental power seems to be too weak 
to gather any of the dreamstuff, but if you U)se a green berry you now will be
able to pull a piece out of the void. U)se the first piece you get and you 
should be able to imagine a 20th century M-60 machine gun.

Now ready the weapon, aim at Raxachk through the wall of his citadel and
shoot him with the machine gun. A graphic sequence shows you putting the
three fuel canisters on the realizer, then activating it to send the
phlogonistite back to your companions in Argyre. You friends then help you
transfer back to your body, and just as Raxachk said, mass destruction begins
in the form of "mars" quakes. You must get all three 10 pound canisters back
to Carnegie at Mons Olympus where everyone is waiting to launch the cannon.
All the members of both expedition as well as the Martians from Hellas in
their new bodies are here, and each has his or her own short message to tell
you. T)alk to Carnegie and then sit back to watch the endgame sequence, which
explains (in part) how Mars as we know it today came to be.

WORLDS OF ULTIMA II: MARTIAN DREAMS is published and distributed by Origin.

This walkthru is copyright (c) 1991 by Venger. All rights reserved.