using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;
namespace MFerCubedsp
{
    public partial class frmMF : Form
    {
        //playsound
        [DllImport("coredll.dll", EntryPoint = "PlaySoundW")]
        private extern static int PlaySoundW(string lpszName, int hModule, int dwFlags);
        [DllImport("coredll.dll", EntryPoint = "GetCapture")]
        private static extern IntPtr GetCapture();
        [DllImport("coredll.dll", EntryPoint = "GetWindow")]
        private static extern IntPtr GetWindow(IntPtr hWnd, int uCmd);
        [DllImport("coredll.dll", EntryPoint = "SendMessage")]
        private static extern uint SendMessage(IntPtr hWnd, uint msg, uint wParam, uint lParam);

        // Constants required for interop
        const int GW_CHILD = 5;
        const uint EM_SETINPUTMODE = 0x00DE;


        public static void SetInputMode(Control ctrl, InputMode mode)
        {
            // Get the handle for the current control
            ctrl.Capture = true;
            IntPtr h = GetCapture();
            ctrl.Capture = false;

            // Get the child window for the control
            IntPtr hEditbox = GetWindow(h, GW_CHILD);
            // Set the input mode
            SendMessage(hEditbox, EM_SETINPUTMODE, 0, (uint)mode);
        }
        // Input mode enumeration
        public enum InputMode
        {
            Spell = 0,
            T9 = 1,
            Numbers = 2,
            Text = 3
        }


        public static void Play(string sFilename)
        {
            int hResult = PlaySoundW(sFilename,0,0);
        }

        public frmMF()
        {
            InitializeComponent();
        }

        private void frmMF_KeyDown(object sender, KeyEventArgs e)
        {
            if (txtDialString.Visible == false)
            {
                switch (e.KeyCode)
                {
                    case System.Windows.Forms.Keys.F1:
                        // Soft Key 1
                        // Not handled when menu is present.
                        break;
                    case System.Windows.Forms.Keys.F2:
                        // Soft Key 2
                        // Not handled when menu is present.
                        break;
                    case System.Windows.Forms.Keys.Enter:
                        // Enter
                        Play(@"\Program Files\MFerCubed\MF2600.wav");
                        break;
                    case System.Windows.Forms.Keys.D1:
                        // 1
                        lbldial.Text += "1";
                        Play(@"\Program Files\MFerCubed\MF1.wav");
                        break;
                    case System.Windows.Forms.Keys.D2:
                        // 2
                        lbldial.Text += "2";
                        Play(@"\Program Files\MFerCubed\MF2.wav");
                        break;
                    case System.Windows.Forms.Keys.D3:
                        // 3
                        lbldial.Text += "3";
                        Play(@"\Program Files\MFerCubed\MF3.wav");
                        break;
                    case System.Windows.Forms.Keys.D4:
                        // 4
                        lbldial.Text += "4";
                        Play(@"\Program Files\MFerCubed\MF4.wav");
                        break;
                    case System.Windows.Forms.Keys.D5:
                        // 5
                        lbldial.Text += "5";
                        Play(@"\Program Files\MFerCubed\MF5.wav");
                        break;
                    case System.Windows.Forms.Keys.D6:
                        // 6
                        lbldial.Text += "6";
                        Play(@"\Program Files\MFerCubed\MF6.wav");
                        break;
                    case System.Windows.Forms.Keys.D7:
                        // 7
                        lbldial.Text += "7";
                        Play(@"\Program Files\MFerCubed\MF7.wav");
                        break;
                    case System.Windows.Forms.Keys.D8:
                        // 8
                        lbldial.Text += "8";
                        Play(@"\Program Files\MFerCubed\MF8.wav");
                        break;
                    case System.Windows.Forms.Keys.D9:
                        // 9
                        lbldial.Text += "9";
                        Play(@"\Program Files\MFerCubed\MF9.wav");
                        break;
                    case System.Windows.Forms.Keys.F8:
                        // *
                        lbldial.Text = "KP+";
                        Play(@"\Program Files\MFerCubed\MFKP.wav");
                        break;
                    case System.Windows.Forms.Keys.D0:
                        // 0
                        lbldial.Text += "0";
                        Play(@"\Program Files\MFerCubed\MF0.wav");
                        break;
                    case System.Windows.Forms.Keys.F9:
                        // #
                        lbldial.Text += "+ST";
                        Play(@"\Program Files\MFerCubed\MFST.wav");
                        break;
                }
            }
        }

        private void menuDialString_Click(object sender, EventArgs e)
        {
            switch (menuDialString.Text){
                case "Dial String":
                    lblDialInst.Visible = true;
                    txtDialString.Visible = true;
                    menuDialString.Text = "Dial";
                    menuStop.Text = "Cancel";
                    txtDialString.Focus();
                    SetInputMode(txtDialString, InputMode.Numbers);
                    break;
                case "Dial":
                    lblDialInst.Visible = false;
                    txtDialString.Visible = false;
                    DialString(txtDialString.Text);
                    menuDialString.Text = "Dial String";
                    menuStop.Text = "Stop";
                    break;
                default:
                    lblDialInst.Visible = false;
                    txtDialString.Visible = false;
                    break;
            }
        }
        private void DialString(string sNumber)
        {
            foreach (char c in sNumber)
            {
                switch (c)
                {
                    case '1':
                        // 1
                        lbldial.Text += "1";
                        Play(@"\Program Files\MFerCubed\MF1.wav");
                        break;
                    case '2':
                        // 2
                        lbldial.Text += "2";
                        Play(@"\Program Files\MFerCubed\MF2.wav");
                        break;
                    case '3':
                        // 3
                        lbldial.Text += "3";
                        Play(@"\Program Files\MFerCubed\MF3.wav");
                        break;
                    case '4':
                        // 4
                        lbldial.Text += "4";
                        Play(@"\Program Files\MFerCubed\MF4.wav");
                        break;
                    case '5':
                        // 5
                        lbldial.Text += "5";
                        Play(@"\Program Files\MFerCubed\MF5.wav");
                        break;
                    case '6':
                        // 6
                        lbldial.Text += "6";
                        Play(@"\Program Files\MFerCubed\MF6.wav");
                        break;
                    case '7':
                        // 7
                        lbldial.Text += "7";
                        Play(@"\Program Files\MFerCubed\MF7.wav");
                        break;
                    case '8':
                        // 8
                        lbldial.Text += "8";
                        Play(@"\Program Files\MFerCubed\MF8.wav");
                        break;
                    case '9':
                        // 9
                        lbldial.Text += "9";
                        Play(@"\Program Files\MFerCubed\MF9.wav");
                        break;
                    case '*':
                        // *
                        lbldial.Text = "KP+";
                        Play(@"\Program Files\MFerCubed\MFKP.wav");
                        break;
                    case '0':
                        // 0
                        lbldial.Text += "0";
                        Play(@"\Program Files\MFerCubed\MF0.wav");
                        break;
                    case '#':
                        // #
                        lbldial.Text += "+ST";
                        Play(@"\Program Files\MFerCubed\MFST.wav");
                        break;
                }
            }
        }

        private void menuStop_Click(object sender, EventArgs e)
        {
            switch (menuStop.Text)
            {
                case "Cancel":
                    lblDialInst.Visible = false;
                    txtDialString.Visible = false;
                    menuDialString.Text = "Dial String";
                    menuStop.Text = "Stop";
                    break;
                case "Stop":
                    this.Close();
                    break;
            }
        }
    }
}