;********************************************************
;* Suppressed Sync PIC CABLE Descrambler                *
;* with Autolevel adjust and autostart                  *
;* Finnish Westcoast type                               *
;* Started: 17/1-99                                     *
;* Author: Elvis The Great                              *
;* 8MHz XTAL, 0.5 uS CYCLE                              *
;* RB0 = Sync Input                                     *
;* RA0 = Check point for lines containing bad sync      *
;* RA1 = output on frame (also check point)             *
;* RA2 = Output                                         *
;* RA3 = Sample backporch of hsync                      *
;* Program Version:                                     *
;* Beta 1.0                                             *
;* Modification from the MaxiNEW decoder /Alpha 1.01    *
;* everything marked new is mod to orig code.           *
;********************************************************

	LIST    P=16C84
	include "P16C84.INC"    
	
FUSES           equ     0x09    ; XT,PWRT,CP
Teller1         equ     0x0C    ; Sync width for Frame interrupt
LINE            equ     0x0D    ; Lines waiting after Frame
CNT_LOW         equ     0x0E    ; low byte line counter
CNT_HIGH        equ     0x0F    ; high byte line counter
				; these should investigate line 307
				; and skip it as it contains no sync

;----------------------------------------------------   
	org     00h
	goto    start

;--- INTERRUPT  ----------------------------------------------- 

	org     04h             ;Interrupt in frame on long sync pulse 
	MOVLW   0x12            ; -2
	MOVWF   LINE
	CALL    FRAME
	clrf    INTCON          ; disable ints
	CLRW
	MOVWF   CNT_HIGH        ; clear counter
	MOVWF   CNT_LOW

	retfie
	
;---- INIT    -------------------------------------------------

start:  BSF     STATUS,RP0
	CLRW
	MOVWF   TRISA           ; Set PortA as OUT
	MOVLW   0xff
	MOVWF   TRISB           ; Set PortB as Inn
	movlw   B'11010000'
	movwf   OPTION_REG

	BCF     STATUS,RP0
	CLRF    INTCON
	CLRW                    ; Clear counter
	MOVWF   CNT_LOW
	MOVWF   CNT_HIGH

;********************************************************
; Main :
;********************************************************

MAIN    BTFSC   PORTB,0         ; Wait for a sync input
	GOTO    MAIN
        bsf     PORTA,3         ; sample the backporch, new
        bcf     PORTA,3         ;                     , new

        clrf    INTCON          ;Disable Frame Interrupt
;        NOP                    ;remove due to sample , new

	BSF     PORTA,2         ; Set Output
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1        1c
	BTFSC   STATUS,2        ; if z=1 then                            1c
	INCF    CNT_HIGH,1      ; inc high                               1c
	MOVF    CNT_HIGH,1      ;                                        1c
	BTFSC   STATUS,2        ; if !zero                               1c
	GOTO    Waitline1       ;     line  ovf  frame                  1(2)
	MOVLW   0x1C            ; W = 307 - 256 - 20 = 31d = 0x1F        1c
				; (not properly working with 0x1f..)
				; therefore 0x1c
	SUBWF   CNT_LOW,0       ; W = CNT_LOW - W                        1c
	BTFSC   STATUS,2        ; if !zero result ...                    1c
	goto    Make4lines1     ; ... make 4 lines after each other w/o sync
				; in between                             1(2)

	goto    Waitline2       ; else goto waitline2                    1(2)

Waitline1 
	MOVLW   0x03            ;
	SUBWF   CNT_LOW,0
	BTFSC   STATUS,2
	GOTO    Make4lines
        NOP                     
	
Waitline2 
	movlw   0x1D            ; Wait loop for 1 Vide line 
	movwf   Teller1         ; 14c
Wait1   decfsz  Teller1         ; 16+13=29, 29+1+28*2 =86c
	goto    Wait1 
	
;        nop                    ;remove due to sample, new
	MOVLW   0xE0            ;Enable Frame Interrupt
	MOVWF   TMR0
	MOVLW   0xA0
	MOVWF   INTCON          ;5sc
	
	BCF     PORTA,2         ;1c Stop Output

	NOP                     ; Wait some nop's until we
                                ; are in middle of linesync (7 nops)
	NOP
	NOP
        NOP
	nop
	NOP
	nop
	GOTO  MAIN              ; do this for everyline until we get frame inerrupt

;----------------------------------
Make4lines1
	NOP
Make4lines      
;        NOP                    ; remove due to sample, new
	MOVLW   0x1E
	MOVWF   Teller1         ;15c from output set
Wait11  DECFSZ  Teller1         ;16+14=30,30+1+29*2 =89c
	GOTO    Wait11
	BSF     PORTA,0         ; set check point       3c
	BCF     PORTA,2         ; clear output
	
	MOVLW   0x06            ; horizontal blanking on line 1
	MOVWF   Teller1
Wait12  DECFSZ  Teller1
	GOTO    Wait12
	NOP
	BCF     PORTA,0         ; clear check point
	BSF     PORTA,2         ; set output

	MOVLW   0x21            ; Wait for one line
	MOVWF   Teller1         ;2c
Wait13  DECFSZ  Teller1         ;32+1=33,33+1+32*2=98c
	GOTO    Wait13
	
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1
	BTFSC   STATUS,2        ; if z=1 then
	INCF    CNT_HIGH,1      ; inc high 
	NOP
	BSF     PORTA,0
	BCF     PORTA,2         ;clear output (hor. blank line 307)

	MOVLW   0x06            ; horizontal blanking on line 2
	MOVWF   Teller1
Wait14  DECFSZ  Teller1
	GOTO    Wait14
	NOP
	BCF     PORTA,0         ; clear check point
	BSF     PORTA,2         ; set output

	MOVLW   0x21            ; Wait one line
	MOVWF   Teller1         ;2c
Wait15  DECFSZ  Teller1         ;32+1=33,33+1+32*2=98c
	GOTO    Wait15
	
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1
	BTFSC   STATUS,2        ; if z=1 then
	INCF    CNT_HIGH,1      ; inc high 
	NOP
	BSF     PORTA,0
	BCF     PORTA,2         ;clear output (hor. blank line 308)
	
	MOVLW   0x06            ; horizontal blanking on line 3
	MOVWF   Teller1
Wait16  DECFSZ  Teller1
	GOTO    Wait16
	NOP
	BCF     PORTA,0         ; clear check point
	BSF     PORTA,2         ; set output

	MOVLW   0x21            ; Wait one line
	MOVWF   Teller1         ;2c
Wait17  DECFSZ  Teller1         ;32+1=33,33+1+32*2=98c
	GOTO    Wait17
	
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1
	BTFSC   STATUS,2        ; if z=1 then
	INCF    CNT_HIGH,1      ; inc high 
	NOP
	BSF     PORTA,0
	BCF     PORTA,2         ;clear output (hor. blank line 308)
	
	MOVLW   0x06            ; horizontal blanking on line 4
	MOVWF   Teller1
Wait18  DECFSZ  Teller1
	GOTO    Wait18
	NOP
	BCF     PORTA,0         ; clear check point
	BSF     PORTA,2         ; set output

	MOVLW   0x21            ; Wait one line
	MOVWF   Teller1         ;2c
Wait19  DECFSZ  Teller1         ;32+1=33,33+1+32*2=98c
	GOTO    Wait19
	
	MOVLW   0xE0            ;Enable Frame Interrupt
	MOVWF   TMR0
	MOVLW   0xA0
	MOVWF   INTCON          ;
	
	NOP                     ;5c
	BCF     PORTA,2         ;clear output (hor. blank line 308)

	NOP                     ; wait until middle of line sync
	
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1
	BTFSC   STATUS,2        ; if z=1 then
	INCF    CNT_HIGH,1      ; inc high 
	INCF    CNT_LOW,1       ; increment counter f+1->f when 1
	BTFSC   STATUS,2        ; if z=1 then
	INCF    CNT_HIGH,1      ; inc high 

	GOTO    MAIN            ; Start over again

;------- Frame interrupt part -------------
; Same as above until finished with frame

FRAME   BTFSC   PORTB,0
	GOTO    FRAME

	NOP
	NOP

        BSF     PORTA,1         ; SET FELT

	movlw   0x22
	movwf   Teller1
Wait2   decfsz  Teller1
	goto    Wait2 
	nop                     ; remove 1 nop  for NTSC
	nop

	BCF     PORTA,1

	DECFSZ  LINE
	GOTO    NIKK
	RETURN

NIKK    NOP
	NOP
	NOP
	nop

	GOTO    FRAME

;-------------------------------------  
	ORG    0x2007
	DW     FUSES

	END



