/*
 * maintainers nightmare -- there are a few differences between kernels...
 *
 */

#if LINUX_VERSION_CODE >= 0x020100
#include <asm/uaccess.h>
#include <linux/vmalloc.h>
#else
#include <linux/bios32.h>
#include <linux/ipc.h>

#define mdelay(x) udelay((x)*1000)
#define signal_pending(current)  (current->signal & ~current->blocked)
#define sigfillset(set)

static inline int time_before(unsigned long a, unsigned long b)
{
	return((long)((a) - (b)) < 0L);
}

static inline unsigned long
copy_to_user(void *to, const void *from, unsigned long n)
{
        memcpy_tofs(to,from,n);
	return 0;
}

static inline unsigned long
copy_from_user(void *to, const void *from, unsigned long n)
{
        memcpy_fromfs(to,from,n);
	return 0;
}
#define ioremap vremap 
#define iounmap vfree
#endif

#if LINUX_VERSION_CODE < 0x02017f
static inline void schedule_timeout(int j)
{
	current->timeout = jiffies + j;
	schedule();
}
#endif

#if LINUX_VERSION_CODE < 0x020300
#define DECLARE_MUTEX(foo)         struct semaphore foo = MUTEX
#define DECLARE_MUTEX_LOCKED(foo)  struct semaphore foo = MUTEX_LOCKED
#define WAIT_QUEUE                 struct wait_queue*
#define init_waitqueue_head(wq)    *(wq) = NULL;
#else
#define WAIT_QUEUE                 wait_queue_head_t
#endif
