/*
 * cablecrypt-color-c.c
 *
 * Copyright (C) 2002 TWISTI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <time.h>
#include "cablecrypt.h"
#include "ccd.h"
#include "ronnyvideo.h"
#include "esnelDecode.h"


extern int locking;
extern int fps;
extern int picoffset;

static long counter = 0;
static int isRonnyVideoInitialised = 0;
static time_t time_now, time_before;
static long counter_before;


void decodeFrameCableCryptColorC(unsigned char *dest, unsigned char *src, int xsize, int xsize_src, int ysize, int dest_xsize)
{
    int picoff;

/*     fprintf(stderr, "xsize=%d xsize_src=%d ysize=%d dest_xsize=%d\n", xsize, xsize_src, ysize, dest_xsize); */
    
    if (!isRonnyVideoInitialised) {
        isRonnyVideoInitialised = 1;
        initRonnyVideo(dest);
        time_before = time(0);
    }

    /* calc pic offset */
    picoff = calcPicOffset(src, dest, dest_xsize);
    picoffset = PICOFF - picoff;

    /* drawing frame */
    decodeFrameEsnelColorC(src, 0, dest_xsize * 2);

    time_now = time(0);
    counter++;

    if (time_now > time_before) {
        fps = counter - counter_before;
        counter_before = counter;
        time_before = time_now;
    }

    adjustPllFrequency(locking, picoff);
}
