/*
 * cablecrypt-color-double-mmx.c
 *
 * Copyright (C) 2002 TWISTI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "cablecrypt.h"
#include "ccd.h"
#include "ronnyvideo.h"
#include "esnelmDecode.h"


extern int locking;
extern int fps;
extern int picoffset;

static long counter = 0;
static int isRonnyVideoInitialised = 0;
static time_t time_now, time_before;
static long counter_before;


void decodeFrameCableCryptColorDoubleMMX(unsigned char *dest, unsigned char *src, int xsize, int xsize_src, int ysize, int dest_xsize)
{
    int x, y;
    unsigned short *psrc;
    unsigned short *pdest;

    int picoff;
    int e, f;
    int g;

    unsigned short a, b, c, d;
    unsigned short px1red, px1green, px1blue;
    unsigned short px2red, px2green, px2blue;
    unsigned short px3red, px3green, px3blue;
    unsigned short px4red, px4green, px4blue;
    

    if (!isRonnyVideoInitialised) {
        isRonnyVideoInitialised = 1;
	initRonnyVideo(dest + dest_xsize * 10);
        time_before = time(0);
    }

    /* calc pic offset */
    picoff = calcPicOffset(src, dest, dest_xsize);
    picoffset = PICOFF - picoff;

    /* drawing frame */
    decodeFrameEsnelColorMMX(src, 0, dest_xsize * 2);
    
    psrc = ((unsigned short *) dest) + dest_xsize * (280 - 1);
    pdest = ((unsigned short *) dest) + dest_xsize * (280 - 1) * 2;
    
    e = dest_xsize;
    f = dest_xsize + 1;

    for (y = (280 - 1); y >= 0; y--) {
        for (x = ((dest_xsize - 35) / 2 - 1); x > 5; x--) {
	    g = x * 2;

            a = psrc[x];
            b = psrc[x + 1];
            c = psrc[x + e];
            d = psrc[x + f];

            px1red = a & 0x0000f800;
            px1green = a & 0x000007e0;
            px1blue = a & 0x0000001f;

            px2red = b & 0x0000f800;
            px2green = b & 0x000007e0;
            px2blue = b & 0x0000001f;

            px3red = c & 0x0000f800;
            px3green = c & 0x000007e0;
            px3blue = c & 0x0000001f;

            px4red = d & 0x0000f800;
            px4green = d & 0x000007e0;
            px4blue = d & 0x0000001f;

	    pdest[g] = a;
            pdest[g + 1] = (((px1red + px2red) >> 1) & 0x0000f800) | (((px1green + px2green) >> 1) & 0x000007e0) | ((px1blue + px2blue) >> 1);
            pdest[g + e] = (((px1red + px3red) >> 1) & 0x0000f800) | (((px1green + px3green) >> 1) & 0x000007e0) | ((px1blue + px3blue) >> 1);
	    pdest[g + f] = (((px1red + px4red + px2red + px3red) >> 2) & 0x0000f800) | (((px1green + px4green + px2green + px3green) >> 2) & 0x000007e0) | ((px1blue +px4blue + px2blue + px3blue) >> 2);
        }

	psrc -= dest_xsize;
	pdest -= dest_xsize * 2;
    }

    time_now = time(0);
    counter++;
    
    if (time_now > time_before) {
        fps = counter - counter_before;
        counter_before = counter;
        time_before = time_now;
    }

    adjustPllFrequency(locking, picoff);
}
