/*
 * cablecrypt.c
 *
 * Copyright (C) 2002 TWISTI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include "cablecrypt.h"
#include "ccd.h"


extern int locking;

static int plltmp;


/*
void calcfps(time_t &time_before, long counter, long &counter_before, int &fps)
{
    time_t time_now;
    
    time_now = time(0);
    if (time_now > time_before) {
        fps = counter - counter_before;
        counter_before = counter;
        time_before = time_now;
    }
}
*/

int calcPicOffset(unsigned char *psrc, unsigned char *pdest, int dest_xsize)
{
    int i, j;
    int picoff;
    unsigned short *ptmp;
    unsigned char *membase;
    unsigned char *surface;

    /* draw bw bar of the first line */
    membase = psrc;
    surface = pdest;
    membase += PICOFF * 4 + 100 * 4;
	
    for (i = 0; i < 10; i++) {
	cableputline(membase, surface);
	surface += dest_xsize * 2;
    }

    /* find pic offset */
    ptmp = (unsigned short *) pdest;
    picoff = 0;
    
    for (i = 0; i < 420; i++) {
        if ((ptmp[i] & 0x1f) < 7) {
            picoff = i;
            break;
        }
    }

    /* when we lock, remove the sync bar */
    if (locking) {
	ptmp = (unsigned short *) pdest;
	for (i = 0; i < 10; i++) {
	    for (j = 0; j < 410; j++) {
		ptmp[j] = 0;
	    }
	    ptmp += dest_xsize;
	}

    } else {
	ptmp = (unsigned short *) pdest;
	for (i = 0; i < 10; i++) {
	    ptmp[PICOFF] = 0xffff;
	    ptmp += dest_xsize;
	}
    }

    return picoff;
}


void adjustPllFrequency(int locking, int picoff)
{
    if (!locking) {
	plltmp = getPllFrequency();

    } else {
	if (picoff > PICOFF) {
	    setPllFrequency(plltmp - 36);
		
	} else if ((picoff > 1) && (picoff <= PICOFF)) {
 	    setPllFrequency(plltmp + 36);
	}
    }	
}


void cableputline(unsigned char *membase, unsigned char *surface)
{
    unsigned char linebuf[2048];
    unsigned char lumabuf[2048];
    int polarity = 0;

    __asm__ __volatile__ ("pushl  %ebx\n"
			  "pushl  %esi\n"
			  "pushl  %edi");

    __asm__ __volatile__ ("movl  %0, %%esi" : : "m" (membase));

    __asm__ __volatile__ ("xorl  %edx, %edx\n"
			  "xorl  %eax, %eax\n"
			  "movl  $32, %ecx");

    __asm__ __volatile__ ("__detectburst:\n"
			  "movb  (%esi), %al\n"
			  "incl  %esi\n"
			  "addl  %eax, %edx\n"
			  "decl  %ecx\n"
			  "jnz  __detectburst\n"
			  "movl  $0x500, %eax\n"
			  "subl  %edx, %eax\n"
			  "sarl  $4, %eax\n"
			  "pushl  %eax\n"
			  "addl  $64, %esi");
    
    __asm__ __volatile__ ("movl  %0, %%edi" : : "m" (lumabuf));
    
    __asm__ __volatile__ ("pushl  %edi");	/* -O2 workaround */
    
    __asm__ __volatile__ ("movl  $1872, %ecx");

    __asm__ __volatile__ ("__luma_filter1_loop:\n"
			  "xorl  %eax, %eax\n"
			  "xorl  %edx, %edx\n"
			  "movb  (%esi), %al\n"
			  "movb  4(%esi), %dl\n"
			  "incl  %esi\n"
			  "addl  %edx, %eax\n"
			  "movb  %al, (%edi)\n"
			  "incl  %edi\n"
			  "decl  %ecx\n"
			  "jnz  __luma_filter1_loop\n");
    
    __asm__ __volatile__ ("popl  %esi");	/* -O2 workaround */
    
    __asm__ __volatile__ ("popl  %ebx\n"
			  "movl  $357, %ecx\n");
    
/*     __asm__ __volatile__ ("movl  %0, %%esi" : : "m" (lumabuf)); */
    __asm__ __volatile__ ("movl  %0, %%edi" : : "m" (linebuf));
    
    __asm__ __volatile__ ("pushl  %edi");	/* -O2 workaround */

    __asm__ __volatile__ ("__luma_filter2_loop:\n"
			  "xorl  %edx, %edx\n"
			  "xorl  %eax, %eax\n");
    __asm__ __volatile__ ("movb  2(%esi), %dl\n");
    __asm__ __volatile__ ("movb  1(%esi), %al\n");
    __asm__ __volatile__ ("addl  %eax, %edx\n"
			  "movb  3(%esi), %al\n"
			  "addl  %eax, %edx\n"
			  "addl  %edx, %edx\n"
			  "movb  (%esi), %al\n"
			  "addl  %eax, %edx\n"
			  "movb  4(%esi), %al\n"
			  "addl  %edx, %eax\n"
			  "sarl  $1, %edx\n"
			  "addl  %ebx, %edx\n"
			  "sarl  $1, %edx");

    __asm__ __volatile__ ("movl  %0, %%eax" : : "m" (polarity));
    __asm__ __volatile__ ("addl  $5, %esi\n"
			  "orl  %eax, %eax\n"
			  "jz  __nopolarity\n"
			  "negl  %edx\n"
			  "addl  $210, %edx");

    __asm__ __volatile__ ("__nopolarity:\n"
			  "cmpl  $256, %edx\n"			    
			  "jl  __nocliphigh\n"
			  "movl  $255, %edx\n"
			  "jmp  __nocliplow");
    
    __asm__ __volatile__ ("__nocliphigh:\n"
			  "cmpl  $0, %edx\n"
			  "jge  __nocliplow\n"
			  "movl  $0, %edx");

    __asm__ __volatile__ ("__nocliplow:\n"
			  "movb  %dl, (%edi)\n"
			  "incl  %edi\n"
			  "decl  %ecx\n"
			  "jnz  __luma_filter2_loop");

    __asm__ __volatile__ ("movl  %0, %%edi" : : "m" (surface));

    __asm__ __volatile__ ("movl  $357, %ecx");
    
/*     __asm__ __volatile__ ("movl  %0, %%esi" : : "m" (linebuf)); */
    __asm__ __volatile__ ("popl  %esi");	/* -O2 workaround */
    
    __asm__ __volatile__ ("xorl  %ebx, %ebx");
    
    __asm__ __volatile__ ("__display_rgb8_loop:\n"
			  "pushl  %edx\n"
			  "xorl  %edx, %edx\n"
			  "xorl  %eax, %eax\n"
			  "movb  (%esi, %ebx), %al\n"
			  "shrb  $3, %al\n"
			  "addw  %ax, %dx\n"
			  "shlw  $5, %dx\n"
			  "addw  %ax, %dx\n"
			  "shlw  $6, %dx\n"
			  "addw  %ax, %dx\n"
			  "movw  %dx, (%edi,%ebx,2)\n"
			  "popl  %edx\n"
			  "incl  %ebx\n"
			  "decl  %ecx\n"
			  "jnz  __display_rgb8_loop\n"
			  "popl  %edi\n"
			  "popl  %esi\n"
			  "popl  %ebx");
}
