#include "ccd.h"


int lastFreq;

const int BaseFrequency	=  38871250;	/* base frequency */
const int BandLow	=  41000000;	/* lowest possible freq. */
const int BandLowMid	= 160000000;	/* toggle band ctrl freq. */
const int BandMidHigh	= 454000000;	/* toggle band ctrl freq. */
const int BandHigh	= 880000000;	/* highest possible freq. */

const int TunerAddress	= 0xC2;			/* I2C address for tuner */
const int BandCtrlLow	= 0xCEA1;		/* Ctrl code for VHF low */
const int BandCtrlMid	= 0xCE90;		/* Ctrl code for VHF high */
const int BandCtrlHigh	= 0xCE30;		/* Ctrl code for UHF */



VideoInput getVideoinput()
{
	return (VideoInput) BTmm->muxsel;
}

VideoFormat getVideoFormat()
{
	return (VideoFormat) BTmm->format;
}

int getCrystal ()
{
	return BTmm->xtsel;
}

int getAGCDelay()
{
	return BTmm->adelay;
}

int getBurstDelay()
{
	return BTmm->bdelay;
}

int getPllFrequency()
{
	uint64 f = BTmm->pll_f_lo | (BTmm->pll_f_hi << 8) | (BTmm->pll_i << 16);
	f = (f * XT0FREQ) >> 16;
	f /= ((BTmm->pll_c == 0) ? 6 : 4) * ((BTmm->pll_x == 0) ? 1 : 2);
	return (f);
}

bool isPllEnabled()
{
	return BTmm->tgcki;
}

int getVerticalTotal()
{
	return( (BTmm->vtotal_lo | (BTmm->vtotal_hi << 8)) + 1 );
}

int getTest()
{
	return BTmm->test;
}

bool isCrystal0()
{
	return BTmm->csel;
}

bool is525Lines()
{
	return BTmm->numl;
}

bool isDevHLock()
{
	return BTmm->hloc;
}

bool isVideoPresent()
{
	return BTmm->pres;
}

bool isPowerDown()
{
	return( BTmm->clk_sleep == 1 );
}

bool isAnalogThresholdLow()
{
	return BTmm->sync_t;
}

bool isComponentVideo()
{
	return BTmm->o_comp;
}


void setVideoInput( VideoInput data )
{
	BTmm->muxsel = (int) data;
}

void setVideoFormat( VideoFormat data )
{
	BTmm->format = (int) data;
}

void setCrystal (int data)
{
	BTmm->xtsel = (int) data;
}

void setAGCDelay( int data )
{
	BTmm->adelay = data;
}

void setBurstDelay( int data )
{
	BTmm->bdelay = data;
}

void setPllFrequency( int data )
{
	int x,c,i,f;

	x = (data < (XT0FREQ * 2)) ? 1 : 0;
	data *= (x == 0) ? 1 : 2;
	c = (data < (XT0FREQ*8/3)) ? 0 : 1;
	data *= (c == 0) ? 6 : 4;
	i = data / XT0FREQ;
	f = (int) ((((u_int64_t) (data % XT0FREQ) << 16) + (XT0FREQ / 2)) / XT0FREQ);

	BTmm->pll_x = x;
	BTmm->pll_c = c;
	BTmm->pll_i = i;
	BTmm->pll_f_lo = (f & 0xff);
	BTmm->pll_f_hi = (f >> 8) & 0xff;
}

void setPllEnabled( bool data )
{
	BTmm->tgcki = data;
}

void setVerticalTotal( int data )
{
	data--;
	BTmm->vtotal_hi = (data >> 8) & 0xff;
	BTmm->vtotal_lo = data & 0xff;
}

void setTest( int data )
{
	BTmm->test = data;
}

void setPowerDown( bool data )
{
	BTmm->clk_sleep = data;
}

void softwareReset()
{
	BTmm->sreset = 0;
}

void setAnalogThresholdLow( bool data )
{
	BTmm->sync_t = data;
}

void setComponentVideo( bool data )
{
	BTmm->e_comp = BTmm->o_comp = data;
}


AudioSource getAudio()
{
	setGPOE( 0x0f );

	return (AudioSource) getGPData( 0, 1, 0x00 );
}


void setAudio( AudioSource au )
{
	setGPOE( 0x0f );
	setGPData( 0, 1, (int) au, 0x00 );
}


bool isCaptureOddEnabled()
{
	return BTmm->capture_odd;
}

bool isCaptureEvenEnabled()
{
	return BTmm->capture_even;
}

bool isCaptureVBIOddEnabled()
{
	return BTmm->capture_vbi_odd;
}

bool isCaptureVBIEvenEnabled()
{
	return BTmm->capture_vbi_even;
}

bool isCaptureEnabled()
{
	return( BTmm->capture_odd | BTmm->capture_even );
}

bool isCaptureVBIEnabled()
{
	return( BTmm->capture_vbi_odd | BTmm->capture_vbi_even );
}

bool isFifoEnabled()
{
	return BTmm->fifo_enable;
}

bool isRiscEnabled()
{
	return BTmm->risc_enable;
}

bool isDecodeEvenField()
{
	return BTmm->evenfield;
}

bool isDropFields()
{
    return BTmm->dec_field;
}

bool isDropEvenField()
{
	return BTmm->dec_fieldalign;
}

int getDropRate()
{
	return BTmm->dec_rate;
}

int getFieldCount()
{
	return BTmm->fcntr;
}


void setCaptureOddEnabled( bool data )
{
	BTmm->capture_odd = data;
}

void setCaptureEvenEnabled( bool data )
{
	BTmm->capture_even = BTmm->capture_odd = data;
}

void setCaptureVBIOddEnabled( bool data )
{
	BTmm->capture_vbi_odd = data;
}

void setCaptureVBIEvenEnabled( bool data )
{
	BTmm->capture_vbi_even = data;
}

void setCaptureEnabled( bool data )
{
	BTmm->capture_even = BTmm->capture_odd = data;
}

void setCaptureVBIEnabled( bool data )
{
	BTmm->capture_vbi_even = BTmm->capture_vbi_odd = data;
}

void setFifoEnabled( bool data )
{
	BTmm->fifo_enable = data;
}

void setRiscEnabled( bool data )
{
	BTmm->risc_enable = data;
}

void setDropFields( bool data )
{
	BTmm->dec_field = data;
}

void setDropEvenField( bool data )
{
	BTmm->dec_fieldalign = data;
}

void setDropRate( int data )
{
	if (isDropFields())
		data <<= 1;

	BTmm->dec_rate = data;
}


int getBrightness()
{
	return BTmm->bright;
}

int getSaturation()
{
	return( BTmm->sat_u_lo | (BTmm->o_sat_u_hi << 8) );
}

int getContrast()
{
	return( BTmm->contrast_lo | (BTmm->o_contrast_hi << 8) );
}

int getHue()
{
	return BTmm->hue;
}


void setBrightness( int data )
{
	BTmm->bright = data;
}

void setSaturation( int data )
{
	int v = (data * 0x16a) >> 9;

	BTmm->sat_u_lo = data & 255;
	BTmm->sat_v_lo = v & 255;
	BTmm->e_sat_u_hi = BTmm->o_sat_u_hi = (data >> 8) & 1;
	BTmm->e_sat_v_hi = BTmm->o_sat_v_hi = (v >> 8) & 1;
}

void setContrast( int data )
{
	BTmm->contrast_lo = data & 255;
	BTmm->e_contrast_hi = BTmm->o_contrast_hi = (data >> 8) & 1;
}

void setHue( int data )
{
	BTmm->hue = data;
}


bool isGamma()
{
	return BTmm->gamma;
}

bool isAGCFunction()
{
	return BTmm->agc_en;
}

bool isAdaptiveAGC()
{
	return( BTmm->crush == 0 );
}

bool isLowColorAutoRemoval()
{
	return BTmm->o_ckill;
}

bool isCbFirst()
{
	return BTmm->o_cbsense;
}

bool isChromaAGC()
{
	return BTmm->o_cagc;
}

bool isChromaComb()
{
	return BTmm->o_comb;
}

bool isChromaADC()
{
	return( BTmm->c_sleep == 0 );
}

bool isChromaOverflow()
{
	return BTmm->cof;
}

bool isLumaOverflow()
{
	return BTmm->lof;
}

bool isLumaADC()
{
	return( BTmm->y_sleep == 0 );
}

bool isExtFrame()
{
	return BTmm->ext_frame;
}

bool isLumaNotchFilter()
{
	return BTmm->o_lnotch;
}

bool isLumaPeakFilter()
{
	return BTmm->o_peak;
}

bool isLumaDecimation()
{
	return BTmm->o_ldec;
}


void setGamma( bool data )
{
	BTmm->gamma = data;
}

void setAGCFunction( bool data)
{
	BTmm->agc_en = data;
}

void setAdaptiveAGC( bool data )
{
	BTmm->crush = (1 - data);
}

void setLowColorAutoRemoval( bool data )
{
	BTmm->e_ckill = BTmm->o_ckill = data;
}

void setCbFirst( bool data )
{
	BTmm->e_cbsense = BTmm->o_cbsense = data;
}

void setChromaAGC( bool data )
{
	BTmm->e_cagc = BTmm->o_cagc = data;
}

void setChromaComb( bool data )
{
	BTmm->e_comb = BTmm->o_comb = data;
}

void setChromaADC( bool data )
{
	BTmm->c_sleep = (1 - data);
}

void resetChromaOverflow()
{
	BTmm->cof = 0;
}

void resetLumaOverflow()
{
	BTmm->lof = 0;
}

void setLumaADC( bool data )
{
	BTmm->y_sleep = (1 - data);
}

void setExtFrame( bool data )
{
	BTmm->ext_frame = data;
}

void setLumaNotchFilter( bool data )
{
	BTmm->e_lnotch = BTmm->o_lnotch = data;
}

void setLumaPeakFilter( bool data )
{
	BTmm->e_peak = BTmm->o_peak = data;
}

void setLumaDecimation( bool data )
{
	BTmm->e_ldec = BTmm->o_ldec = data;
}


ColorFormat getColorFormat()
{
	return (ColorFormat) BTmm->color_odd;
}

CoringLevel getCoringLevel()
{
	return (CoringLevel) BTmm->core;
}

bool isFullOutputRange()
{
	return BTmm->range;
}

bool isColorBars()
{
	return BTmm->color_bars;
}

bool isByteSwap()
{
	return BTmm->bswap_odd;
}

bool isWordSwap()
{
	return BTmm->wswap_odd;
}


void setColorFormat( ColorFormat data )
{
	BTmm->color_even = BTmm->color_odd = data;
}

void setCoringLevel( CoringLevel data )
{
	BTmm->core = data;
}

void setFullOutputRange( bool data )
{
	BTmm->range = data;
}

void setColorBars( bool data )
{
	BTmm->color_bars = data;
}

void setByteSwap( bool data )
{
	BTmm->bswap_even = BTmm->bswap_odd = data;
}

void setWordSwap( bool data )
{
	BTmm->wswap_even = BTmm->wswap_odd = data;
}


int getGPOE()
{
	return( BTmm->gpoe & 0x00ffffffL );
}

int getGPData( int frombit, int tobit, int offset )
{
	int mask;

	if (frombit > 31 || tobit > 31 || frombit > tobit || offset > 0x100)
		return(0);

	mask = (1 << (1 + tobit - frombit)) - 1;
	return( (BTmm->GPData >> frombit) & mask );
}


void setGPOE( int data )
{
	BTmm->gpoe = data & 0x00ffffffL;
}

void setGPData( int frombit, int tobit, int value, int offset )
{
	int mask;

	if (frombit > 31 || tobit > 31 || frombit > tobit || offset > 0x100)
		return;

	mask = (1 << (1 + tobit - frombit)) - 1;
	BTmm->GPData = (BTmm->GPData & (~(mask << frombit))) | (value & mask);
}




int getRiscIPC()
{
	return BTmm->risc_ipc;
}

int getRiscPC()
{
	return BTmm->risc_pc;
}


void setRiscIPC( int data )
{
	BTmm->risc_ipc = data;
}

void setRiscPC( int data )
{
	BTmm->risc_pc = data;
}

int hdelay;				/* cached HDELAY value */
int hactive;			/* cached HACTIVE value */
int field_height;		/* digital height in scanlines */


void scalerInit()
{
	int f, a;

	f = (BTmm->o_hscale_hi << 8) | BTmm->o_hscale_lo;
	hdelay = ((f + 4096) * ((BTmm->o_hdelay_msb << 8) | BTmm->o_hdelay_lo) + 2048) >> 12;
	hactive = ((f + 4096) * ((BTmm->o_hactive_msb << 8) | BTmm->o_hactive_lo) + 2048) >> 12;

	f = (BTmm->o_vscale_hi << 8) | BTmm->o_vscale_lo;
	a = (BTmm->o_vactive_msb << 8) | BTmm->o_vactive_lo;
	field_height = (f == 0) ? a : (512L*a / (0x2200L - f) - 2);
	doScale();
}

void doScale()
{
	short s;
	int field_width = (BTmm->o_hactive_msb << 8) | BTmm->o_hactive_lo;
	int vactive = (BTmm->o_vactive_msb << 8) | BTmm->o_vactive_lo;

	if (hactive == 0)
		s = 0;
	else
		s =  (short) ((2L*hdelay*field_width / hactive + 1) >> 1);

	BTmm->e_hdelay_msb = BTmm->o_hdelay_msb = (s >> 8) & 3;
	BTmm->e_hdelay_lo = BTmm->o_hdelay_lo = s & 0xff;

	if (field_width == 0)
		s = 0;
	else
		s = (short) ((8192L*hactive / field_width - 8192L + 1) >> 1);

	BTmm->e_hscale_hi = BTmm->o_hscale_hi = (s >> 8) & 0xff;
	BTmm->e_hscale_lo = BTmm->o_hscale_lo = s & 0xff;

	if (field_height == (vactive >> 1) || field_height == -2)
		s = 0;
	else
		s = (short) ((0x10000L + 512L - ((512L*vactive /field_height + 1) >> 1)) & 0x1FFFL);

	BTmm->e_vscale_hi = BTmm->o_vscale_hi = (s >> 8) & 0x1f;
	BTmm->e_vscale_lo = BTmm->o_vscale_lo = s & 0xff;
}

void getAnalogWindow( int *_hdelay, int *_hactive, int *_vdelay, int *_vactive )
{
	if (_hdelay != null)
		*_hdelay = hdelay;

	if (_hactive != null)
		*_hactive = hactive;

	if (_vdelay != null)
		*_vdelay = (BTmm->o_vdelay_msb << 8) | BTmm->o_vdelay_lo;

	if (_vactive != null)
		*_vactive = (BTmm->o_vactive_msb << 8) | BTmm->o_vactive_lo;
}

void getFieldSize( int *width, int *height )
{
	if (width != null)
		*width = (BTmm->o_hactive_msb << 8) | BTmm->o_hactive_lo;

	if (height != null)
		*height = field_height;
}

HorizFilter getHFilter()
{
	return (HorizFilter) BTmm->o_hfilt;
}

int getVFilter()
{
	return BTmm->o_vfilt;
}


void setAnalogWindow( int _hdelay, int _hactive, int _vdelay, int _vactive )
{
	hdelay = _hdelay;
	hactive = _hactive;

	BTmm->e_vactive_msb = BTmm->o_vactive_msb = (_vactive >> 8) & 3;
	BTmm->e_vactive_lo = BTmm->o_vactive_lo = _vactive & 0xff;
	BTmm->e_vdelay_msb = BTmm->o_vdelay_msb = (_vdelay >> 8) & 3;
	BTmm->e_vdelay_lo = BTmm->o_vdelay_lo = _vdelay & 0xff;

	doScale();
}

void setFieldSize( int width, int height )
{
	BTmm->e_hactive_msb = BTmm->o_hactive_msb = (width >> 8) & 3;
	BTmm->e_hactive_lo = BTmm->o_hactive_lo = width & 0xff;
	field_height = height;

	doScale();
}

void setHFilter( HorizFilter data )
{
	BTmm->e_hfilt = BTmm->o_hfilt = (int) data;
}

void setVFilter( int data )
{
	BTmm->e_vfilt = BTmm->o_vfilt = data;
}
