/*
 * esnelDecode.h
 *
 * Copyright (C) 2002 TWISTI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _ESNELDECODE_H
#define _ESNELDECODE_H

#include <math.h>
#include "ccd.h"

#define decWidth  	414			/* decoded (display/output) width */
#define decHeight	280			/* decoded (display/output) height */
#define rawWidth 	2268			/* input (raw) width */
#define rp              rawWidth		/* pitch */
#define	rawHeight	293			/* input (raw) height */
#define rawOffset	5 * rawWidth - 102	/* offset of first pixel */

/* decode (static) */
#define divPi		(0x80000000L / M_PI)
#define FcHF0		((int) (283.75 * 0x100000000L / rawWidth))
/* #define FcHF0		((int) (229.25 * 0x100000000L / rawWidth)) */
#define FcVF0		((int) (  -.25 * 0x100000000L))

#define FIX64(n)	((int) (64 * n + .5))
#define MAKEQW(n)	(((int64) (n & 0xffff) << 48) | ((int64) (n & 0xffff) << 32) | ((int64) (n & 0xffff) << 16) | (int64) (n & 0xffff))


extern bool isInitialized;


void decColorBurstWidth();
void incColorBurstWidth();
int getColorBurstWidth();


extern int brightness;
extern int contrast;
extern int saturation;
extern bool adjust_luma_level;

void InitializeDecoder();
void SetPixels(int y, int pitch);
void GetLumaSamples(unsigned char *src, int lladjust, int brightness, int contrast);
void GetChromaSamples(unsigned char *src, unsigned int cbPhase, unsigned int cbHF, unsigned int cbVF, int saturation, int vsaturation);
void GetColorBurstData(unsigned char *src, unsigned int *cbPhase, unsigned int *cbHF, unsigned int *cbVF, int *cbOdd);

int BrightnessUp();
int BrightnessDown();
int ContrastUp();
int ContrastDown();
int SaturationUp();
int SaturationDown();
int AdjustLumaLevel();
int InvertPolarity();
int InvertChroma();

void decodeFrameEsnelColorC(unsigned char *src, int offset, int pitch);
     
#endif
