/*
 * esnelDecodeCommon.c
 *
 * Copyright (C) 2002 TWISTI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ccd.h"
#include "esnelDecode.h"


bool isInitialized = false;


int _cb_width = 0;

void decColorBurstWidth() { if (_cb_width > 0)  _cb_width--; }
void incColorBurstWidth() { _cb_width++; }
int getColorBurstWidth() { return _cb_width; }


int brightness = 37;
int contrast = 174;
int saturation = 245;

bool adjust_luma_level = false;
bool invert_polarity = false;
bool invert_chroma = false;

int correct_brightness = 0;


int BrightnessUp()
{
    if (brightness < 511) brightness += 2;

    return brightness;
}

int BrightnessDown()
{
    if (brightness > -511) brightness -= 2;

    return brightness;
}


int ContrastUp()
{
    if (contrast < 511) contrast += 2;

    if (correct_brightness == 1 && contrast > 1) {
        brightness -= 135;
        correct_brightness = 0;
    }

    return contrast;
}

int ContrastDown()
{
    if (contrast > -511) contrast -= 2;

    if (correct_brightness == 0 && contrast < 0) {
        brightness += 135;
        correct_brightness = 1;
    }

    return contrast;
}


int SaturationUp()
{
    if (saturation < 511) saturation += 2;

    return saturation;
}

int SaturationDown()
{
    if (saturation > -511) saturation -= 2;

    return saturation;
}


int AdjustLumaLevel()
{
    adjust_luma_level = !adjust_luma_level;

    return adjust_luma_level;
}


int InvertPolarity()
{
    invert_polarity = !invert_polarity;
    contrast = -contrast;

    if (correct_brightness == 0 && contrast < 0) {
        brightness += 135;
        correct_brightness = 1;
    } else if (correct_brightness == 1 && contrast > 1) {
        brightness -= 135;
        correct_brightness = 0;
    }

    return invert_polarity;
}


int InvertChroma()
{
    invert_chroma = !invert_chroma;
    saturation = -saturation;

    return invert_chroma;
}
