#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>

#include <stdio.h>
#include <stdlib.h>

#include <lirc/lirc_client.h>

#include "lirc-support.h"

static int lircd_fd = -1;
static struct lirc_config *config = NULL;

enum command_index {
  SAMPLE,
  KEYPAD,
  NO_INDEX,
};
static void lirc_sample_cb (String *pieces, int num_pieces)
{
  int i;
  fprintf(stderr, "lirc_sample_cb trigered:\n");
  for(i=0; i<num_pieces; i++)
    fprintf(stderr, "\t%s\n", pieces[i]);
}

struct command {
  char *name;
  void (*func)(String *pieces, int num_pieces);
  enum command_index index;
  int min_pieces;
  int XtAction;
} commands[] = {
  {"Channel", NULL, NO_INDEX, 1, TRUE},
  {"SetChannel", NULL, NO_INDEX, 2, TRUE},
  {"FullScreen", NULL, NO_INDEX, 1, TRUE},
  {"CloseMain", NULL, NO_INDEX, 1, TRUE},
  {"Volume", NULL, NO_INDEX, 2, TRUE},
  {"Pointer", NULL, NO_INDEX, 1, TRUE},
  {"ShowFPS", NULL, NO_INDEX, 1, TRUE},
  {"Tune", NULL, NO_INDEX, 2, TRUE},
  {"VerticalTotalUp", NULL, NO_INDEX, 1, TRUE},
  {"VerticalTotalDown", NULL, NO_INDEX, 1, TRUE},
  {"PllFrequencyDown", NULL, NO_INDEX, 1, TRUE},
  {"PllFrequencyUp", NULL, NO_INDEX, 1, TRUE},
  {"Locking", NULL, NO_INDEX, 1, TRUE},
  {"TestRegister", NULL, NO_INDEX, 1, TRUE},
  {"AdjustLumaLevel", NULL, NO_INDEX, 1, TRUE},
  {"InvertPolarity", NULL, NO_INDEX, 1, TRUE},
  {"InvertChroma", NULL, NO_INDEX, 1, TRUE},
  {"BrightnessDown", NULL, NO_INDEX, 1, TRUE},
  {"BrightnessUp", NULL, NO_INDEX, 1, TRUE},
  {"ContrastDown", NULL, NO_INDEX, 1, TRUE},
  {"ContrastUp", NULL, NO_INDEX, 1, TRUE},
  {"SaturationDown", NULL, NO_INDEX, 1, TRUE},
  {"SaturationUp", NULL, NO_INDEX, 1, TRUE},
  {"VersionInfo", NULL, NO_INDEX, 1, TRUE},
  {"sample_func", lirc_sample_cb, NO_INDEX, 1, FALSE},
  {"sample_index", NULL, SAMPLE, 1, FALSE},
  {"sample_both", lirc_sample_cb, SAMPLE, 1, FALSE},
  {"keypad", NULL, KEYPAD, 2, FALSE},
  {NULL, NULL, 0, 0, 0}
};

static String *chop(char *command, int *num_pieces)
{
  static String command_copy = NULL;
  static String *pieces = NULL;
  static int max_pieces = 0;
  char *end;

  if(pieces == NULL){
    pieces = malloc(sizeof(String));
    max_pieces = 1;
  }

  if(command_copy)
    free(command_copy);
  command_copy=strdup(command);

  *num_pieces = 0;
  pieces[(*num_pieces)++] = command_copy;

  end= strchr(command_copy, ' ');
  
  while (end != NULL) {
    if(*num_pieces+1 > max_pieces)
      pieces = realloc(pieces, ++max_pieces*sizeof(String));
    pieces[(*num_pieces)++] = end+1;
    *end = '\0';
    end = strchr(end+1, ' ');
  }
#if 0
  fprintf(stderr, "chop: ");
  for(i=0; i< *num_pieces; i++)
    fprintf(stderr, "%s:", pieces[i]);
  fprintf(stderr, "%d\n", *num_pieces);
#endif
  return pieces;
}

static void lirc_callback(XtPointer closure, int *source, XtInputId* id)
{
  char *code;
  char *c;
  int ret;
  Widget tv = closure;

  if(lirc_nextcode(&code)!=0) {
    fprintf(stderr, "Error reading lirc code\n");
    return;
  }
  if(code==NULL) return;
  while((ret=lirc_code2char(config,code,&c))==0 && c!=NULL) {
    struct command *command = commands;
    String *pieces;
    int num_pieces;
    XEvent event;

    pieces = chop(c, &num_pieces);

    for(; command->name != NULL; command++)
      if (strcmp(command->name, pieces[0])==0)
	break;

    fprintf(stderr, "\nReceived: \"%s\"\n",c);
    
    if(command->name){
      if(num_pieces < command->min_pieces){
	fprintf(stderr, "lirc_supp: not enough arguments: \"%s\"\n", c);
	return;
      }
      if(command->func)
	command->func(pieces, num_pieces);
      switch (command->index){
      case SAMPLE:
	fprintf(stderr, "sample_switch_case trigered\n");
	break;
      case KEYPAD:
	fprintf(stderr, "someone send keypad %s and I don't know what to do\n",
		pieces[1]);
	break;
      default:
	event.type = LASTEvent;
      }
      if(command->XtAction){
	XtCallActionProc (tv, pieces[0], &event, pieces+1, num_pieces-1);
      }
    } else {
      fprintf(stderr, "Unknown lirc action: %s\n", c);
    }

  }
  free(code);
}

void lirc_supp_init(XtAppContext app_context, Widget tv)
{
  if (debug) {
    fprintf(stderr, "lirc_init\n");
  }

  if (-1 == (lircd_fd=lirc_init("CableTV", TRUE))){
    fprintf(stderr, "Error conecting to lircd\n");
    lirc_deinit();
    fprintf(stderr, "Remote control support will not be available\n");
    return;
  }

  if(lirc_readconfig(NULL, &config, NULL)!=0) {
    fprintf(stderr, "Error reading lirc config file\n");
    lirc_freeconfig(config);
    fprintf(stderr, "Remote control support will not be available\n");
    return;
  }

  XtAppAddInput(app_context, lircd_fd,
		(XtPointer)XtInputReadMask,
		(XtInputCallbackProc)lirc_callback,
		(XtPointer)tv);
  return;
}
